### 背景信息
大脑不可靠，不要靠大脑记东西。大脑会遗忘。
知识库，是一个永恒文件夹，外置记忆，记录你的所有知识，避免你遗忘。并且它要有极高的读写速度，使得【读：扫一眼你就加载所有知识的记忆】【写：每学一个新知识，它都会自动记录到知识库里】。
### 错误方法：从上向下
定义：开一个文件夹，或者一个导图，或者一个多级缩进文档，划分知识目录、填充内容。
缺点：没法复用。你不想看自己过去做的文件夹/导图/多级文档。
### 错误方法：从上向下+交集法
定义：每次要整理时就构建一次。构建多了，自然就记住了。
优点：取其精华，去其糟粕，可以很好的剔除知识库里的糟粕。
缺点：很可能【构建九次，分数：60，70，80，85，88，80，72，65，55】。
类似于，让你写一个研究文档，你写完了，一个月后你记忆基本清空、给你同样的素材让你重写一个研究文档，你大概会写的更好。但这样执行九个月，每月一篇，你大概第五个月的文档最好、第九个月的文档最差。
### 错误方法：从上向下+实时更新
定义：整理完毕之后，未来每次学到新知识，就更新这个文件夹/导图/多级文档。
缺点：难以坚持（忘记）。
### 错误方法：从上向下+延时更新
定义：整理完毕之后，当未来需要再次整理时，直接强制在原文件夹/导图/多级文档上更新。
缺点：难受，难以坚持（放弃）。你没法想起来【你有哪些新知识】，你只能想起来【你有哪些知识（未必新）】，而【想起来一个知识、观察旧文档中有没有它】很慢很痛苦。
### 错误方法：从下向上
定义：每次学到一个知识，就写成一个知识卡片。攒几千上万个知识卡，然后分类排布。
优点：永恒进步。至少，每次记录一个知识卡，你就有一份进步。
缺点：不胜枚举。本质是：你只有知识卡，根本没法分类管理。
- 难以搜索，难以总览，从下向上得到的结构通常很差
- 垃圾一堆，有许多错误的、重复的、矛盾的知识（矛盾：宁为玉碎不为瓦全、留得青山在不怕没柴烧）
- 没法复用。分类了也没用，你会继续攒卡片，未来当你某天想了解知识库全貌时，因为过去的分类垃圾，所以你又会重新分类。而几万个卡片的分类累死你。
形式：多种多样。除了纸质卡之外，软件的永恒话题的每一个消息也可以视为一个知识卡。
### 错误方法：从下向上+双向优化
定义：从下向上的分类整理之后，再从上向下的捋一遍，对于空缺的地方填补。
缺点：缺的地方一天也填不完。很多地方欠缺的知识卡都需要你调查与学习几个小时才能写上一个卡，而你欠缺的卡通常是你已有的卡的三倍。即，你一万个卡，双向时你会发现你还要补三万个卡。
这个方法在其他时候可能是优点（比如写小说时，列举十个好情节、从下向上再双向时你会创新三十个好情节出来），但在此处是缺点。
### 错误方法：从下向上+T型
定义：从下向上的分类整理之后，后续新的卡片独立在分类之外，等又攒一批之后、再将那些新的卡片整理到过去的分类之中。
优点：这类似于【从上向下+延时更新】，但解决了【没法想起来有哪些新知识】的问题。
缺点：跟从下向上没什么区别。知识库一团垃圾，会导致你崩溃、不想做。
### 错误方法：从下向上+T型+筛选
定义：在上一节的基础上，允许删除新的或旧的卡片，从而保持知识库干净。
缺点：可能把有用的东西删了。
### 正确方法：从下向上+T型+垃圾库
定义：以这样的结构制作知识库：
- 核心区
	- A类
	- B类
	- C类
- 垃圾区
	- ……
	- 2025.1.12：XXX
	- 2025.2.26：XXX
	- 荣誉区
- 卡片1
- 卡片2
- ……
其中，核心区是指正常的从上向下的分类文件夹，卡片1卡片2是当前写的卡片。每写100个卡片左右时（卡片区太多），选择一些好的卡片移动到核心区的对应位置，然后在垃圾区以当前日期新建一个文件夹、把其余卡片丢进去。不定期可以调整核心区的结构，并丢弃一些核心区的卡到荣誉区、从垃圾区翻出来一些卡加到新的核心区。平时还可以经常扫一扫荣誉区，回忆回忆自己为什么曾经错误的至少两次认为它们正确（一次记录卡片、一次整理到核心区），以及思考【它们真的错误吗？】。

宗旨：降速与约束。
- **以垃圾区作为重构核心区的依据**：核心区要想重构出一个分类，那么、那个分类必须在垃圾区里有卡片能作为其下级。
- **以核心区作为记录新卡牌的依据**：拿着锤子找钉子，想着核心区去在生活中察觉与记录知识卡。当你核心区记录【人际交流】时，你自然会关注人际交流方面的知识卡；当你核心区没有【人际交流】而你想加入这个分类时，你先回忆几个知识、创建几个知识卡，然后新建这个分类、并在后续几天里你会补充很多这个类的新知识卡。

优点：消除了从下向上的所有副作用，知识库既干净又丰富。
- 自动复用：每一次100卡，你都会自动复习一遍核心区架构。每一次调整核心区，你都会随机复习一些垃圾区的卡片。
- 成本低廉，执行舒服，不难坚持。

形式：Obsidian文档或发言标签
- Obsidian文档：按上面的结构划分。还可以在核心区加一个【外置记忆】分类，记录自己的密码之类的东西，有一个新账号就可以开一个新文档写，整理的时候丢到那个外置记忆目录里。并且你的很多草稿也可以丢到垃圾区里。
- 发言标签：在软件发言时书写【#关键词/待定/XXX】这样的标签，这就相当于【卡片1】；后续整理的时候将其整理为【#关键词/人际交流/XXX】之类的，那么就相当于进入了核心区；垃圾区则是【#关键词/废弃/XXX】。即，视为这样的结构：
	- A类
	- B类
	- C类
	- 待定区
	- 废弃区
	- 荣誉区
### DeepSeek-R1总结
将知识库视为有机生命体，允许其生长、修剪与重构。（评价：优秀的概括。更准确的说：知识库才是自己，肉体只是空壳。也基于此：数据非常重要，面谈非常糟糕，因为面谈会导致数据丢失；而文字交流后可以对有价值的发言整理为卡片。）