### 前言
执悲今厄在文档《万剑归宗》中提到：扫雷有一定的量子演算，但不多。
我注意到：
- 可以通过在扫雷中加入视距来实现更多的量子演算。（视距：原本扫雷能看到周围一圈的雷数。如今改为可以看到一圈或两圈或三圈的。）
- 扫雷的设定量不多，我应当能在工程中逐渐优化设定来实现完美。
- 目前团队中的程序库积累了很多，实现扫雷并不难。
基于此，我设计了这款扫雷改版，命名为超级扫雷。
我负责设计，团队中一些其他成员负责编程、运营。开发用时一周。
目前已发布在Steam。
### 超级扫雷设计
一个关卡的设定由【宽度，高度，雷数，石数】构成。
雷随机分布。
石的格子不是雷，但也不提供数字。开局可见所有石。
石中心密集、边缘稀疏。（算法：对一个格子坐标，计算它的中心程度，并基于此计算它是石的概率）

一个关卡的设定并不直接书写，而是由【宽度，高度，零比例，石峰】四个参数生成。
零比例，是指从期望来看、这个关卡中会有多少比例的格子是0。（是0：3×3区域内无雷。玩家对关卡难度最直观的认知是零比例，而非雷数。）
石峰，是指中央格子是石的概率是多少。
在生成时，使用一个辅助函数：首先计算【指定宽高雷，零数多少】，再取逆得到【指定宽高零，雷数多少】。

一个关卡的参数也不直接书写。而是由一组关卡的参数生成，参数包括【宽度，高度，石峰，零最高，零最低】。
五十关每七关一组，分为八组（七七四十九+1）。
每一组的第一关的零比例使用最低零，最后一关使用最高零，期间匀速变化。

关卡组参数也不直接书写。而是书写首尾关卡设定，自动计算组（按等差或等比）。
首尾关卡设定由反馈修正得到。（反馈修正：游玩，针对不好的地方修改。）
### 坑：匀速表
匀速表：每一关，【宽度，高度，雷数，石峰】都均匀上升。
坑点：不要出现大于十项的多参数匀速表，因为玩家会腻。
建议：把某些参数改为阶梯式的。例如，宽高七关一变。
### 坑：雷数表
雷数表：表中有名为雷数的列作为自变量列。
坑点：雷数会随着宽高的变化而变化。即便你已经调试设计好了雷数，未来修改宽高时也需要重新调试雷数。
建议：把雷数作为因变量。自变量可以是【雷比例】（雷数相对于面积的比例。等价于一个格子是雷的概率）。
### 坑：雷比例表
雷比例表：表中有名为雷比例的列作为自变量列。
坑点：雷比例并不同构于难度。即，保持雷比例不变，改变宽高，并不能保证难度不变。难度是指玩家要花多大神力才能赢（神力包括峰值计算难度与自信崩溃程度（即无解概率），不包括重复劳动）。
建议：使用零比例作为自变量。零比例同构于难度。
### 坑：捋线法
捋线法：拿住线的一端，从它出发将线不断捋直。此处是指从第一关开始，第二关第三关……这样运行、检查、修改。
坑点：麻烦。而且一旦改设计，检查又从头来，高成本。
建议：扽线法：拿住线的两端，把线拉直。此处是只检查第一关与最后一关，然后生成中间关卡设定（基于阶梯与零比例）。
### 坑：大矩形
大矩形：在没有石头时，当有一片大的矩形区域全部被打开或插旗时，进度往往就难以推进了。此时二三视距都无法提供帮助。无论如何调整宽度、高度、雷数，都：要么无法避免大矩形，要么难度太简单。
建议：加入石头。石头不是雷，开局即可见，但也无法打开、无法获知其数字。石头会破坏大矩形的形成。
### 优点：量子演算
量子演算，是指【我不确定你是什么，但我知道你不是什么。且我可以基于此而推断出他是什么】。
换句话说，量子演算的核心思想是【不确定也含有信息，可以利用，不要忽视】。
简单的量子演算例如：ABC三个空位，填XYZ三个内容（一样一个），其中A可能是XY，B可能是YZ，C可能是XY。基于此，可以推断出B是Z。
（注：之所以称之为量子演算，取自【传统演算是基于一些东西的状态来推导其他东西的状态。而量子演算是基于一些东西的量子态来推导其他东西的状态。量子态：可能是X或Y】）

量子演算是对排除法的进阶。排除法是单性质时的量子演算。
排除法：ABC三个空位，有一个是Z。其中A不是，C不是。基于此，可以推断出B是Z。
排除法是一个强大的方法，广泛应用于凶案推理、选择题、决策、维修（故障定位）、医疗诊断。
量子演算的一个重大应用是万剑归宗：综合大量信息，解出优雅结论。例如【综合扫雷类游戏的数值所需要满足的各个条件，得到最终数值设定公式】【经济学中，综合影响市场供给与需求的各个条件，得到供需平衡时的价格公式】。

量子演算也是对慧眼的进阶。慧眼是单素材时的量子演算。慧眼也强调【不确定，也有信息，不要忽视】。
慧眼：虽然我不知道谁是Z，但我知道A一定不是。
之所以被称为慧眼，是因为这样的案例：
- 虽然我不知道如何实现AGI，但我知道：如果你认为造出完美婴儿比造出完美成人难，那么你一定无法实现AGI，我不会投资你。
- 虽然我不知道一个好项目/好丈夫/好领导/好机会/好理论是怎样的，但我知道它不会是怎样的/我知道凭XX信息无法确定XX是否是好/坏的。

经典扫雷有少量的量子演算，但不多。
本游戏引入了视距与石头，增加了量子演算。
经典扫雷数字3就是多，数字4就是可怕。而本游戏数字5678都比比皆是，但可以通过复杂的量子演算求解。
### 数值设计师的基本能力
数值设计师需要如下能力：
- 图灵完备理念。相信【一切重复得你烦的东西都有不重复的简单解】。不要硬调试一遍又一遍。
- 数学能力。例如，能够计算【给定宽高与雷数，求零数的期望】。
- 升维意识。当【无论如何调整参数值，都无法实现想要的效果】时，立刻意识到这一点，并增加新的参数类型，这就是升维。（四个参数的不同取值构成一个四维空间，一个关卡就对应这个四维空间的一个点。五个参数的话，一个关卡就对应五维空间的一个点。）
- 表格操作知识。能熟练使用Excel表格的各个功能（尤其是函数，实现【改一个数值，其他数值自动变化】），或者使用代码生成Excel。最终的设计以Excel的形式提交。
#游戏数值设计/图灵完备理念
#游戏数值设计/数学能力
#游戏数值设计/升维意识
#游戏数值设计/表格操作知识
#01思维能力/量子演算
#01思维能力/万剑归宗
#游戏设计/坑/不好玩：匀速表
#游戏设计/坑/改动麻烦：因变量表
#游戏设计/坑/改动麻烦：捋线法
#游戏设计/坑/不好玩：低维无解