## 作者
作者：执悲今厄
时间：2024.8.25，全文写作用时三小时（一气呵成）
## 摘要
人的行为的原因包括先天与后天。明确一切先天时，就是AGI的实现之时。
要明确先天，可以对比多个案例、自我认知。
要自我认知，可以使用内觉解释法。

本文介绍了自我认知与内觉的严格定义。如果你有如下想法，那么可以读本文：
- 我看了你的大量其他文档，其中总说自我认知。到底什么是自我认知？
- 你搞AGI为什么总搞自我认知？有了自我认知就能实现AGI吗？
- 你的其他文档中的自我认知让我惊叹。我想训练提高我的自我认知能力，我该怎么做？

本文较为晦涩与严谨。不建议在碎片时间阅读，不建议在疲劳时阅读。建议在学习、办公、纳凉、足疗时阅读。
## 关键词
#关键词/自我认知 
#关键词/内觉 
#关键词/AGI 
#关键词/定义 
#关键词/理念 
## 正文
### 自我认知
有AB二人。
当A处于环境T时，A会做行为X。
当B处于同样的环境T时，B不会做X，而是会做Y。
你可代入A，认为X合理；亦可代入B，认为Y合理。
你通过自我认知，写出一个先天算法P，两个后天信息QA与QB，满足：
- A的行为X的原因是【P+QA】。
- B的行为Y的原因是【P+QB】。

注：先天算法与后天信息，见于本文后面的【双天理念】章节。
注：可以不只是AB二人，而是多人，然后同样找一P多Q。
注：Q可能是时序的。时序，见于本文后面的【时序】章节。
注：当说【A的行为X的原因是【P+QA】】时，需要且只需要确保两点：
第一，符合逻辑。即，P+QA=X。
第二，符合事实。即，A确认拥有QA。
不需要确认A拥有P。P的正确性由不可否决性保证。不可否决性，见于本文后面的【内觉解释法】章节。

问：这就是自我认知？这是处理AB，哪里有【自我】？
答：你代入AB，通过处理你自己来处理AB。

问：我看你其他文档都是处理自己的行为。为什么这里不是处理自己？
答：这里包括处理自己。AB可以是其他时间线的你（当然也可以是别人）。
例如，你在T时做X。此时你可以想象【如果存在另一个时间线，那里的你过去没经历过XX（或额外经历过XX），那么那个你会做Y】。
以本世界的你为A，以想象的时间线中的你为B，自我认知。

注：旧版理论中将自我认知定义为【认知自己的行为的原因】，将想象时间线称为【幻想法】，将内觉称为【观察法】。
新版理论修改了自我认知的定义，定义直接使用AB，从而也就没有幻想法一说了。观察法也改名为了【内觉解释法】。
### 双天理念
双天理念：人的任意行为的原因的格式都是【先天算法+后天信息】。
先天算法：所有健康婴儿所共有、在保持大脑健康的情况下从出生至死亡皆不变的算法。
后天信息：人出生后获得的信息，包括五感输入与自我输入（思考）。注意，自我输入也是一个行为，同样基于先天算法与后天信息。
推论：明确先天算法，写成代码，就是AGI。
推论：明确一个人的先天算法与后天信息，明确其当前环境，则可准确预测其行为。

问：何谓理念？
答：理念，区别于公理与推论。
公理：不证自明，世所公认。
理念：不证自明，未必公认。理念不合者免谈。
推论：可证明。

问：何谓理念不合？请以双天理念为例。
答：先天理念、灵魂理念、双天理念，互相不合。
先天理念：人的性格/天赋为先天，每个人的先天不同。后天有影响，但影响甚微。
灵魂理念：存在自由意志，不可基于先后天而准确预测人的行为。

问：为何你反对先天理念？
答：
第一，信仰。不存在命运与天赋，人定胜天。
第二，经验。拆解了大量的【人与人的差距】格式的天赋，它们本质都是后天长期形成的，可以训练获得。之所以有的人没刻意训练就有，是因为初始随机选择+后续正循环强化。【人人不同但无优劣】格式的天赋也有拆解，本质是因婴儿或童年时期的信息的影响。
正循环强化：越做越熟悉，越熟悉越做，如此正循环强化。
第三，演化。除非DNA突变，否则智人之间的先天差距不会大；突变者少且多为病。

问：为何【理念不合者免谈】？双方理念各有原因，为何不讨论？
答：无法互相说服。即便指出理念的错误，理念所有者也会觉得【我的有错，不代表你的是对的。可能是我这个还需要做一些补丁】。
大量的思考与研究都基于理念，理念如地基般不可轻动，改变理念的唯一方式就是研究碰壁。
因此讨论理念没有意义，浪费时间。一个理念的瑕疵，理念所有者自己清楚，比反对者更清楚。但所有者相信【这些瑕疵不重要，未来可以找到补丁来修复】。
### 时序
非时序：P+信息Q=行为X。
时序：
- P+信息Q+噪音=念头O1
- P+信息Q+噪音+念头O1=念头O2
- P+信息Q+噪音+念头O1+念头O2=行为X
噪音：同人在同时刻对同环境面对同棋局的走法混沌，因噪音影响。  
混沌：如果信息充分则结果可计算，但一点看似不重要的微小信息变化都会导致结果大变。  

注：低权性：各选择无明显优劣时，噪音影响才明显。优劣差距越大，噪音影响越低。  
注：时序低权性：权重只对单回合负责。对于时序决策，如果第一个念头的各起点无明显优劣，那么噪音影响明显，且后续方向走偏后可能不再回归，从而可能【终点优劣差距大，但噪音影响大】。  
注：全时序性：所有决策都是时序的。那些看似非时序的决策本质是只伴生了错误回合、重复回合、阶段回合；朴素的时序决策是指带回头回合的。
回合：一个时序包含多个回合。一个非时序包含一个回合。  
正确回合：想到好决策，同意  
错误回合：想到坏决策，否决  
重复回合：正确回合后再次重复正确回合，加深确认。或者错误回合后再次重复确认错误。
回头回合：想到过去（几秒内）想到过的决策，态度与过去的态度不一致（态度：同意或否决）
阶段回合：得到了一个阶段成果。虽然态度是同意，但没有结束决策。
### 内觉解释法
研究方法
假说演绎法：泛用于科学研究。观察旧现象，提出猜想来解释旧现象，基于猜想预测新现象，实验验证新现象。若验证成功，则视为猜想正确。
内觉解释法：仅用于自我认知。观察众多现象，分别得到内觉结果，汇总提出无孤的PQ解释，观察更多现象，发现反例，否决旧的P并提出新的P，直至无法否决，此时视为P正确。（内觉与无孤见下）

注：内觉可保证不会【否决旧的P之后无法提出新的P】。
#### 内觉
**定位**
你在T时做X。
你通过内觉，得到一个指令序列S_i，满足：
- 第一时刻，指令S_1生效
- 第二时刻，指令S_2生效
- 第三时刻，指令S_3生效
- ……
- 第N时刻，指令S_N生效。S_N是X
- 对任意S_i，S_(i-1)对S_i影响大。特别的，S_(1-1)视为环境T。
**定义**
内觉：通过冥想或其他静心观察自我的方式，来察觉自己那些一闪而过却又对最终决策有重要影响的念头。
环境T：一个时间切片。不仅是时刻，还包括此时刻的地理环境与记忆。
指令生效：做出运动或产生念头。即前文所说的行为、决策。但行为与决策有歧义（行为可能专指运动，决策可能专指意识观察到的指令或指令序列），因此这里严格称为指令。
做出运动：控制肌肉运动。
产生念头：产生想法，没有运动。
**性质**
注：通常而言，除了S_N之外，其他的S_i都是念头，而不是运动。
注：S_i基于S_i发生时的记忆。S_i发生时的记忆，可以简单视为S_(i-1)时的记忆+S_(i-1)。（实际还有记忆库整理与注意力干预，此处略）
注：这个指令序列，即前文所说的时序。
#### 无孤理念
无孤理念：先天算法中不会存在大量的孤立补丁。
补丁：一套算法无法实现某个效果，于是在算法基础上加一个补丁来实现。
外补丁：这个补丁无法融入这个算法，无法用除直接的【没有这个补丁就无法运行】之外的理由来解释这个补丁存在的原因。
内补丁：补丁可以融入算法，之前算法的疏忽了某一个东西、这里加上。这个补丁显然就该存在在这里，很和谐，分析上即便没有它、也可以基于某些推理而预测出它的存在。
孤立补丁：外补丁，且只用于补的那一套算法，不与其他算法相互作用。

问：为什么持有无孤理念？
答：
第一，美。带有大量孤立补丁的算法是很丑的。
第二，演化。演化是能用就行，这导致一个功能几乎必然与其他功能耦合。即便存在外补丁，外补丁也不会是孤立的，一个外补丁会同时用于补多个算法，因为其他算法基于外补丁的存在而会退化。
第三，经验。研究经验表明，许多看似孤立的补丁都是错的，是一个更本质的先天算法与一个【大多数人都会有的后天信息】的结合。
### 更多问题
问：如何提高自我认知能力？你文档中也没说啊
答：按定义训练。对一个事情内觉念头，对两个事情对比解释。参考本文的：
- 内觉的定位
- 内觉的定义
- 内觉解释法的定义
- 自我认知的定位

问：自我认知可以实现AGI，但要到什么程度的自我认知呢？如何衡量进度？
答：需要初代机与迭代环境。见于：[[内觉迭代法：AGI的一种实现方式]]

问：目前你的研究进度如何？
答：初代机有了。缺乏迭代环境，因此需要投资。投资详情见于：[[AGI社会性游戏商业计划书]]
目前三线齐做：
- 拉投资
- 自己构建迭代环境
- 研究更多人脑原理，从而在无迭代环境的条件下优化初代机、优化【未来迭代时的修正效率】。