## 总述
EVE中的模拟装备系统很有趣。  
现实中的电脑DIY也很有趣。  
本文分析一下电脑DIY有趣的本质，并尝试将其偏移到游戏设计中。  
分析方式是抽象+验证：  
第一步：抽象出电脑DIY的一个性质。  
第二步：尝试将这个性质偏移到游戏中，判断这样的游戏是否有电脑DIY的感觉。  
第三步：如果第二步判断为否，那么就再抽象出电脑DIY的一个性质，添加到游戏中。  
第四步：反复执行上述步骤，直至判断为是。  
## 性质：海量选择、组合
电脑DIY时存在海量的配件型号选择。EVE中也是存在海量的装备选择。  
并且不只是选择，还是组合。每次选择的并不是最终的电脑，而是电脑的一个零件。组合使得选择的复杂度几何上升。
## 性质：价格带来的无完爆
A完爆B，是指在一切方面A都优于B。  
海量选择+无完爆，是指在这海量的选择中、任何两个选择之间都不存在完爆关系。  
使用价格，可以轻松实现无完爆。对于A强B弱的两个零件，只要A的价格更贵、那么A就无法完爆B。  

无完爆使得海量的选择成为【真海量】，而不是可以剪枝的【假海量】。
## 性质：对数性
指数增长，是指后期少量的操作带来巨大的增长。  
对数增长，是指后期大量的操作带来少量的增长。简单的操作即可达成80%的优秀、大量的操作才能达到90%。  
好的游戏中应当有大量的玩法，每个玩法都应当是对数的。  
EVE做到了这一点。电脑DIY也做到了这一点。  
对数的玩法会导致：玩家可以永远不来玩它，但一旦决定玩了，那么就能收获许多乐趣与知识。  

问：电脑DIY怎么就对数了？  
答：玩家可以不需要DIY，直接购买整机，也可以获得不错的性能与价格。这就是简单的操作实现80%的优秀。
## 性质：不可能三角
上面说了价格无完爆。但对于有钱而言，价格就不再是负面因素，但此时DIY依然有趣，趣味在于不可能三角。  
不可能三角：ABC三个条件不可能同时满足，但是可以同时满足其中的任意两个。  
这会使得玩家查阅大量型号的零件、绞尽脑汁的优化方案来尝试让ABC同时满足。在这个过程中收获乐趣并掌握知识（零件信息）。  

在CPU的选择中是不可能两角：【单核性能】【核心数量】无法同时满足。  
线程撕裂者虽然同时满足二者，但其二者都不是最优的，单核性能不如Core、核心数量不如霄龙。  
## 性质：负面属性调控
除了正面属性之外（频率、核心），还有许多负面属性，比如：  
- 价格  
- 耗电  
- 发热（通常等于耗电）  
- 工作温度（超额会坏）  
- 内存限制  
- 稳定性（不蓝屏）  
- 寿命（过了寿命之后更加不稳定）  
- 缓存（命中率）  
- 体积（能否装进笔记本、台式机箱）  
- 内存条数量  
- 适配主板（影响硬盘数量、内存型号、显卡型号等）  
- 对多CPU的支持情况  
## 高阶抽象性质：可望不可即
不可能三角，负面属性调控，这些都属于这个高阶抽象性质：可望不可即。  
玩家可以看到自己想要实现的是什么效果，但是就是无法实现。  
想要实现的是：三角全满足，无负面属性。  
## 性质：损耗
EVE中，再强的舰船也有死亡的可能。玩家的目标并不是配置出最强的舰船，而是配制出性价比最高的舰船。  
电脑也有一些此性质。电脑会损耗，完美寿命只有五年。  
将这个偏移到游戏之中：（也借鉴一下游戏中的耐久设计）  

- 角色与装备只可以经历一定量的战斗（大约是满强度纯战斗时间1小时，通常是十小时），之后就会永久损坏、需要重新购买。  
- 玩家可以购买一些推荐的、配置好的全装角色。也能获得不错的效果。玩家可以不关心角色配置，只关注游戏中的其他玩法，也能获得完整的游戏体验。  
- 玩家可以自己DIY角色。角色与装备有海量的选择，越好的装备价格越贵。  
- 单装备存在不可能三角，装备之间的组合也存在不可能三角。玩家会对理想的角色属性有一个预期，但以三角的形式无法达成那个预期（三角形式：任何一个部分属性都可以达成，但无法同时达成所有属性）。  
- 装备会有许多负面属性，不同装备的各个负面属性强度不同。部分负面属性可用其他手段弥补。负面属性与其他属性也构成不可能三角。  

这样的设计应该不错，判断通过。
## 具体设计草案
（注：草案：不是游戏的具体设计。只是一个草稿，最终未必采纳）
首先把CPU的词条偏移为战斗词条：

魂台（CPU）：  
- 魂念（频率）：使用单个术法时的难度解析速度。如果一个术法难度100，魂念200，那么0.5秒解析完毕。解析时间与灵气调用时间之和为技能前摇。  
- 魂窍（核心）：可以同时使用多少个术法  
- 念痕（缓存）：如果念痕容量200，刚刚释放了两个难度100的术法，那么再次释放这两个术法时无需解析  
- 魔念（发热）：越高，心魔积累速度越快。术法使用时，心魔积累。心魔多时术法有概率释放失败。心魔会随时间自然减少  
- 不侵：免疫的心魔量  
- 食气：气府速度限制  
- 照气：气府容量限制  
- 境界：道府五行限制  
- 照道：道府五道限制  
- 稳定：在0心魔状态下依然术法失败的概率  
- 寿命：过了寿命之后不稳定度开始不断提高  

魂香（散热）：  
- 驱魔（散热）：加速心魔减少。

气府（内存、硬盘）：  
- 容量（内存容量）：灵气总量  
- 速度（内存速度）：如果一个术法消耗100灵气，气府速度50，那么释放这个术法时前摇2秒

道府（内存、硬盘）：  
- 五行：境界，能否链接一个魂通（魂通：装备、法宝、术法、功法等）  
- 五道：能链接多少魂通  
- 五变：魂通顺序影响

躯体（机箱、显示器、键盘）：  
- 体积 
- 质量

到这里就差不多了，虽然没有得到最终的方案，但未来可以从其他的角度出发来设计、并借鉴此处的设计，从而将结果推得更远。  
（也许是从副本的角度出发。可望不可即的【望】除了【三角满足】与【无负面】之外，还有一个下级是【击败某副本】。）
#游戏设计/01理论设计：卖点（爽的本质是学习）/可望不可即：【选择X能满足需求】居然是错的/希望：海量选择＋排列组合＋无完爆
#游戏设计/01理论设计：卖点（爽的本质是学习）/可望不可即：【选择X能满足需求】居然是错的/希望：对数性
#游戏设计/01理论设计：卖点（爽的本质是学习）/可望不可即：【选择X能满足需求】居然是错的/绝望：副作用
#游戏设计/01理论设计：卖点（爽的本质是学习）/可望不可即：【选择X能满足需求】居然是错的/绝望：不可能三角
#游戏设计/01理论设计：卖点（爽的本质是学习）/可望不可即：【选择X能满足需求】居然是错的/绝望：战斗损失