### 原始问题
电脑装机选购配件很有趣。之前对此有过研究：[[游戏研究：从CPU看角色设计]]。
不过最近考虑到一个反驳点：游戏中玩家的收入会不断增长，如果在游戏中引入【类装机系统】，那么玩家很快就会因为资产膨胀而【无脑选最贵的】，导致装机失去意义。
虽然有两个手段来应对它，但依然不完美：
- 复杂常识。例如，装机中如果你无脑配，那么可能你花了上百万都亮不了机；或者启动一次需要两个小时；或者玩游戏都不如几万元的机器。
- 批量化。后期玩家需要给下属们配备大量的制式“类装机系统”（例如军队制式方案），导致价格又重要了。
对此，我结合EVE与梦幻西游，设计了第三个手段：滞留层。
玩家的资产将长期滞留在某一个层级，对于那个层级而言，“类装机系统”的价格很敏感。例如：
- 地球上，滞留层是【资产10万-100万】。对于这个层级，1-5万元的电脑价格是敏感的。
- EVE中，滞留层是【资产10亿-100亿】。
- 梦幻西游中，滞留层是【69级】。
本文接下来分析这三个滞留层的产生原因。
### 地球滞留原因：娱乐损耗
人们赚到的钱花在了娱乐上，而没有投入到再生产。人们的盈利手段不变，因此资产不变。
见于：[[风神界社会研究：职业主循环]]
摘要：
主循环，是指：人做A获得B，消耗B强化A，做A获得更多的B，以此循环。
在社会性游戏中，所有B都是金钱。陪酒者赚钱、保养、赚更多。矿工赚钱、升设备、赚更多。教师赚钱、学习与交人脉、以帝师为目标。
地球各职业也都存在主循环。之所以看似没有，是因为前期损失过高：绝大多数人把赚到的钱用于享乐花销、损耗了，而没有投入到主循环中。
### EVE滞留原因：风险损耗
人们攒一波钱之后尝试冲击更高层次，但失败了，积蓄花光，从头开始。
EVE的成本与收益曲线不同步。例如，（一次性）成本扩大十倍，（每单位时间）收益只扩大二倍。
这导致：
- 运输类玩家：原本使用10亿的深层空间运载舰、容量五万方、在全世界找高差价的小东西倒卖。如今攒100亿买了一艘旗舰级运载舰、容量百万方、承包一个大军团的快递工作、无需操心货源了，结果一次海盗袭击损失200亿：百亿的旗舰没了，船舱里百亿的货也没了。
- 刷怪类玩家：原本使用10亿的二级科技火力舰、刷四级深渊；然后使用100亿的神装二级科技火力舰、刷五级深渊（收入1.5倍）；然后使用1000亿的限定火力舰、刷六级深渊（收入是五级的1.5倍）。深渊出怪随机、地形随机，一共有几十种怪的组合、每个组合内部只有部分规律，例如元帅组合是【七个统合部深渊舰船】，可能是七个元帅（最难）、也可能是七个安抚者（最简单）、或者三个元帅四个安抚者等，而且舰船的前缀也随机。即便是1000亿的舰船，面对七个毁电元帅也是几乎必死（但这个概率极低极低）；并且海盗玩家可能在深渊出口埋伏着，虽然深渊出口有NPC警察安保，但海盗可以付出10亿左右的成本当着警察面强行击毁你，如果你开着价值千亿的舰船，那么海盗很愿意付出10亿的成本。
- 金融类玩家：除了精炼金属之类的大宗商品之外，其他每一种商品的日市场规模大约在10亿到100亿（一共上万种商品），因此，你可以通过操控一个商品的价格走势来做到100亿资产，但你很难更进一步：因为你赚的钱都是别人亏的钱，一种商品别人投入的钱都没多少。此时，要么控制多个商品，要么尝试控制大宗商品。但是，每一种商品的价格都是诸多因素影响的，理解多个商品的价格会很耗脑细胞；而大宗商品的存量远不止市场表现出的那些，各大军团都有大量库存，当市场价格波动各大军团的自发交易会让市场价格回稳，因此大宗商品价格几乎无法控制；并且想低买高卖也不行，因为大宗商品价格波动很小，低买高卖的收入都不够交贸易税的（贸易税锚定交易额、不锚定交易利润）。
- 海盗类玩家：10亿已经可以做到几乎任何事情了，可以在法外之地交通要道堵门，可以（一次性）在安全区重重安保之中强杀其他玩家（十艘1亿的舰船，可以轻松击杀一个百亿的舰船）。拿着100亿也没什么事情可以做，海盗无法扩大规模，因为肉（其他玩家）就那么多，海盗之间都是竞争关系，海盗还会攻击其他海盗、巴不得世界上只有自己一伙海盗。除非截杀大军团物流，但这样风险也高：军团通常会有快速反应队（一分钟内到场），如果是大规模物资转移（战备、搬家等），那么还会有侦查队与护卫队（随行）、以及第三方第四方（海盗、友方军团、敌方军团等），海盗很容易损失百亿啥也没捞着，而且还容易被军团挂上悬赏、导致反过来【海盗被强杀】：玩家们损失3亿击杀海盗的1亿舰船，但军团给玩家5亿赏金，导致玩家们愿意去杀海盗。
- 士兵类玩家：士兵玩家通常兼刷怪，不打仗的时候就刷怪；也有少量常备军，比如快速反应队。军团战争通常是使用价格4亿左右的舰船，可以买保险、阵亡有补贴，杀敌有军功。除非是特大战役，否则平时如果你要用百亿的旗舰级火力舰参战，那么阵亡没有补贴（补贴还按4亿舰船计算）、自己负责。一个军功（一个人头）大约价值1亿，4亿的舰船一场战役通常只能获得一个左右的军功，但驾驶百亿的舰船一场战役轻松获得十几二十几个军功——但战争中百亿舰船也很脆弱，而且旗舰体型巨大、活靶子，很容易第一场战役就阵亡。
- 工业类玩家：工业是最难平衡的一个东西，EVE给它设计了众多特性也没能让它滞留在10-100亿，最终只能加了一个丑陋的补丁才让工业成功滞留。
	- 特性：类似金融，一个商品市场有限，玩家很容易产能过剩。
	- 特性：材料梯度价格。玩家如果短时间大量采购材料，那么材料价格会越来越贵，导致成本高。因此玩家要想量产一个东西，必须提前几个月开始挂收单慢慢收购材料。
	- 特性：薄利。那些利润高的商品，都是市场极小的，花成本打通工业流水线之后、一天能产数百个、但三天才卖一个；而那些销量高的，利润都是极小的，甚至是负数，需要一大堆降低成本的手段才能把利润变为正的几个百分点（手段：脑浆技能、蓝图研究、高级生产建筑、低税星系）。
	- 补丁：每个玩家最多开启十一个制造项目（对标异星工厂：每个玩家最多放置十一个组装机）。
	- 风神界：EVE的工业问题本质来自于【生产线几乎不可摧毁】，EVE生产线是无实体的，所以才需要这个丑陋补丁。而风神界中生产线直接布置在大地图中、可以被海盗袭击、且势力保护区内的土地昂贵，基于此风神界可以不需要补丁。
- 挖矿类玩家：10亿的挖矿船大约可以做到每小时1亿的收入，100亿的挖矿船可以做到4亿左右、但几乎无法独自活动：它在挖矿的时候需要激活工业模块，会导致自己五分钟内无法移动，面对海盗几乎没有任何生还可能：10亿的矿船至少还能尝试逃跑，而100亿的矿船的工业模块导致它几乎无法逃跑。基于此，100亿的矿船几乎必然需要护卫队。以及，100亿的矿船可以给队友提供挖矿增益BUFF，因此通常是【一个100亿、十个10亿挖矿船、吃增益药剂（乘法叠加），每小时药剂成本5亿、收益50亿、支付5亿护卫工资、支付5亿快速反应队税】。调动其余玩家，本就是巨大的成本，很多时候给钱也没人来；但除此之外，EVE还进一步平衡矿工，加入了矿带容量限制：每个星系每天只产生大约10亿的矿石，第二天刷新；100亿的矿船出动，需要扫多个星系的矿石，很容易把军团驻地内的所有矿石都扫干净，因此一个军团只能养得起一个100亿的矿船。
EVE对每一种玩法都做了精心的数值平衡，使得所有职业都将滞留在10-100亿阶段。（作为对比：军团资产可以万亿甚至百万亿，泰坦万亿、星城万亿）
其关键的核心还是海盗战斗以及军团战争，它们制约各个职业的发展。
### 梦幻：先降后上
当你月入十万时，如果你想月入百万，那么你需要先跌入月入一万。
梦幻西游中，很多副本会限制最高等级，例如限制70级以下进入。并且副本需要组队，很多副本很难，一些最赚钱的限70级的副本，几乎必须全69级神装阵容才能打过。这导致，如果你68级，那么很多人在组队的时候都不收你，你无法挑战那些限制70级以下的副本。
所以，当你处于69时，你就面临一个尴尬的状况：你现在是大哥，可以体验69级之下的一切，但如果你升级到70，那么你将失去那一切，而且没有获得任何新东西：你无法挑战那些限制80级以下的副本，因为其他79级的玩家不带你；即便你勤勤恳恳升到79，他们大概还是不带你，因为你一身都是69级的装备，哪怕是69级的神装也不够打79级副本的。如果你舍弃掉69级的装备，使用79级的：那么很可能你那79级装备还不如69神装。69神装是差，但只是比79神装差，比79白装强。
这导致：如果你试图突破69，进入70，那么你必须先准备好一套79神装。
而你要拥有79神装，你必须挑战79副本。
而你要挑战79副本，你必须先突破69。
死锁。
这也被成为69的诅咒。

并且梦幻西游还有另一个诅咒：你在69停留的时间越久，你将69神装打磨得就越神（强化、宝石、洗练等），那么你丢弃69的代价越大，你就越难以提起勇气进入70。
梦幻西游还贴心的提供了停级功能：玩家可以选择杀敌不再获取经验，从而避免自动升级。
基于此，造就了梦幻西游庞大的69级玩家群体。（几年前是59）

梦幻西游的这种设定，可以很好的兼容【土豪玩家】与【平民玩家】。一方面，官方可以推出109、159等更高的等级，让土豪氪金；另一方面，这些更高的等级不会影响平民玩家，平民玩家自己玩自己的69，主流平民玩家的升级是缓慢的（几年才会升10级）。由于材料通用，因此69玩家可以刷材料卖给土豪玩家，双方也能有良好的互动；以及无级别装备的出现进一步加深了互动。（无级别装备：例如，强度是109级的装备级别，但69级玩家也能穿戴。无级别装备都非常昂贵）
### 总结
风神界会综合【娱乐消耗】【风险消耗】【先降后上】，在炼气境界形成一个滞留层，并且在这个滞留层中设计一个【类装机系统】，让玩家可以深入钻研其搭配。
这个类装机系统的具体题材，大概会是类似于EVE的装配方案、Mindustry的蓝图方案、OpusMagnum的程序方案。
### 评论
执悲今厄：
梦幻西游的先降后上可以称之为【在物质与时间上先降后上】。
物质：玩家强度
时间：玩家需要在一段时间内忍受强度下降（70-78升级过程）
时间看上去没什么用、分析上可修复，但实际上它影响很大，因为对于生成判断的人、时间成本（即，无法立刻解决）是一个重要的否决因子。
类似的：办公室的健身器材和楼下的健身器材差别很大，看上去只有一点点时间成本、没什么差别，但实际上这一点点成本差别最终就会导致90%的运动量减少。