### 爱因斯坦的失败
1900年，物理学中有如下基本存在：
- 质量
- 能量
- 引力
- 电磁力
- 空间
- 时间
爱因斯坦，1879年出生，26岁发表狭义相对论，统一质量与能量，统一惯性参考系下的空间与时间。
36岁发表广义相对论，统一任意参考系下的质量、能量、空间、时间、引力。（质量是浓缩的能量，质量带来时空弯曲，引力来自时空弯曲）
此时，只剩下一个东西没有被统一了：电磁力。
于是爱因斯坦开始研究【如何再把电磁力也统一进来】。
然而，从此直到76岁去世，他都没能成功。

因为后世人们又发现了两个新的基本存在：强核力与弱核力，它们与电磁力紧密相关、但独立于电磁力之外。
爱因斯坦的研究无关强核力与弱核力。这导致他的研究注定失败。
（题外话：杨振宁统一电磁力、强核力、弱核力，并获得诺贝尔奖。）
### 失败的本质
爱因斯坦所面临的困难，本质是这样的：
原本存在这些点：
![[爱因斯坦1.png]]
爱因斯坦画了一条线，统一了蓝色的点：
![[爱因斯坦2.png]]
但下面的黑点让爱因斯坦百思不得其解。晚年一直致力于画一条涵盖蓝点与黑点的线，但一直失败。
后世人们发现了更多的黑点：
![[爱因斯坦3.png]]
宇宙的真相是这样的：
![[爱因斯坦4.png]]
爱因斯坦时代缺乏大量的黑点，所以爱因斯坦统一电磁力的努力失败。
注：我上面只是一个很简单的模型。爱因斯坦实际做的工作虽然可以理解为画线，但画的是上千维度的超面，而不是这种二维平面中的线。
### 思维方式
**当你试图用一个理论解释多个现象时，你要尽可能保证你收集到的现象足够多、足够全面。如果你缺乏了某些关键的现象，那么你的工作将很难进行、并且即便进行下去也往往得到错误的结果。**
研究AGI（通用人工智能），其实也跟爱因斯坦的研究类似，都是【试图用一个理论解释多个现象】。爱因斯坦要解释宇宙，我们要解释人类。
宇宙和生命，大自然的两个最精妙的东西；人类是生命的精华。
基于此，在研究AGI的时候，我们需要保证现象足够多、足够全面，万万不可从少量的现象就开始尝试解释。
AGI所需的现象包括这些：
1. 一般人类行为。视听嗅味触，跑跳喊拉撞。推开窗，向下看，目光所及的人类行为。
2. 心理学人类行为。或者叫，人性。人性的弱点，人性的善恶，教育与学习……人有哪些不完美的地方？
3. 神经疾病人类行为。当人类某些神经受损时，人会有哪些表现？
4. 神经结构。包括神经、分子。
5. 一般念头。观察自己的思考过程。
6. 深层念头。许多念头一般人是观察不到的，需要在宁静的环境、强大的自我观察能力才能发现。
当代对AGI的研究都是基于12345。因为6不可复现，不可实验，论文要求实验或复现。
**但是，深层念头的存在不可忽视，不基于深层念头的AGI研究99%概率失败，如同爱因斯坦不基于强核力与弱核力的研究99%概率失败。**

另一方面，【深层念头是AGI的关键；深层念头不可实验或复现】其实是正常的、必然的。因为如果深层念头可以被实验证明，那么AGI早就问世了。
正如：如果一个人提出一个简单的解法来证明哥德巴赫猜想，那么都不用看他的内容，就可以认为他99.99%概率是错的。
**因为，一个备受瞩目的问题，几乎不可能有简单的解法。如果有，那么别人早就想到了。**
**如果你认为你解决了、或者能解决某一个备受瞩目的问题，那么首先你要回答：你和别人的区别在哪？为什么别人没解决？**
要么你是用非常高级与复杂的办法解决的，要么是你使用了一个正常人的思维死角。
此处，我能实现AGI、而其他人无法实现，就是因为这个死角：研究AGI需要先明确深层念头现象，深层念头现象不可实验与复现，而当代论文体系下的学术体系要求实验或复现。

问：GPTO1就是深层念头。
答：GPTO1的思考不是深层念头，而是一般念头。一般念头是意识驱动的，深层念头不是意识驱动的、但意识可在宁静下观察。
### 深层念头
什么是深层念头？我举个例子。

案例：
假设你走在街上，看到一个盒子。风一吹，盒子飞走了。
然后别人问你：刚才有看到什么特殊的事情吗？
你回答：有个盒子被风吹走了。

思考：
你为什么知道有盒子被风吹走了？
有的研究者说：因为看到盒子被风吹走之后，存储了一个【盒子被风吹走】的记忆。人脑会对看到的所有事情中的特殊的事情、描述之后存储在记忆中。
看上去这个解释合理，但实际上完全错误。
它没有基于深层念头。
深层念头庞大、迅速、非语言，难以描述。尽力描述例如【盒子不见了？盒子应该在这里。盒子没有在这里。盒子在天上。盒子在哪？盒子在天上。盒子在动。我感受到了风压，凉快。我听到了声音。盒子是被风吹的吗？风吹的话它会那样移动。它果然那样移动了】。（本文这里是非常浓缩的描述，实际上还有大量的其他噪音念头、以及主流念头的大量重复，一秒千万念）
注意，深层念头不是意识驱动的。一般人观察不到深层念头，只能观察到【我啥也没想，自然就知道盒子被风吹走了。我没想这么多】。（这也是他们研究AGI失败的原因）
再次强调一遍：你观察不到深层念头，不代表深层念头不存在。意识并不负责决策与行动，意识只是一个天神使者、或者说是一个绝美妃子，能干预国家，但不是真正管事的皇帝或大臣，整个身体没了意识照样可以购物与炒菜，大多数的念头与行动都是跟意识完全无关的。如果意识观察能力强，那么才能观察到那些念头的存在；如果观察能力弱，那么你就会觉得【我啥也没想，自然就这样了】。
**一个AGI算法如果无法实现深层念头，那么100%无法实现让人感受到亲切的AGI，并且在当代99%无法实现AGI。**
### 总结
深层念头，也可以称之为念海。
当代各大AGI理论都不基于念海。所以他们注定失败，只有我将成功。

扩展：（这段看不懂的可以忽视）
念海每秒新生与沉没千万念头，念头的格式为生成判断：生成的是肌肉动作、判断的是布尔值，仅此而已。（后续文档会证明：这个结构可以实现各种高级功能，例如语言、动机、原因、方案等，并且可以被内觉所观察到。其中思考中的无声语言是高频震荡的【喉咙动作，是，喉咙动作，否】。）
生成与判断基于对记忆的联想，同时本身又加入记忆、影响下一次生成判断。记忆本身还会时刻自我整理，使得重点更加突出与清晰。意识本质是记忆中的一组信息、能在记忆整理中屹立不倒（但会被强化或蚕食）、能很大的影响判断（但不影响生成），每一次成功的影响都会导致下一次记忆整理时强化。