### 存在性
生成想法，判断对不对。这是人的思考方式。
案例：
- 下棋。生成一个走法，判断不好，重新生成。
- 发明一种新厨具。生成一个设计，判断不好，重新生成。（这两个案例是可以被意识观察到的生成判断。还有更多不可被观察的，见于其他性质）
### 时刻性
生成判断每帧执行。
### 充要性
智能函数：$F(输入，记忆)=(动作，记忆)$ 
生成判断是智能函数的充分必要实现。
注：智能函数见于[[行为树如何实现动作社会]] 
（修订者注：生成判断具体如何实现智能函数，见于下方【总述】章节）
（修订者注：动作不包含念头，但可以实现念头。见于下方【集群性】章节）
### 独立性
生成与判断彼此独立。
生成器不知道自己生成的指令是否会被判断器通过。
判断器无法改变生成器，只能通过否决来祈祷生成器生成好的方案。
案例：
- 不自律。判断器一直在否决，但生成器一直不生成好的方案（一直生成玩）。（最终判断器因其他性质而通过）
### 噪音性
生成判断受到噪音的影响。并不是唯一输入对应唯一输出（严格说，对应但混沌，一点微小的变化可能以难以理解的方式带来结果的剧变）。
案例：
- 下棋。下象棋围棋，同样的人在同样的局面会做不同的走法，这是受到噪音的影响。
### 自驱性
生成判断可以不需要意识干预。并且，绝大多数生成判断都是无意识的。
案例：
- 梦游的人可以炒菜，开车，躲避障碍物移动。梦游的人无意识。
- 你走路，喝水，具体的动作通常都是无意识的。
### 生成不可控性
意识只可以干预判断，不可以干预生成。
案例：
- 愤怒冲昏头脑。愤怒来自生成，意识只能判断：【不要愤怒】。但判断后再次生成愤怒，最终意识不再坚持否决。
- 当你包藏罪犯时，面对审问，你只能【生成会露馅的答案，否决】，而不能【不生成露馅答案】。
- 如果你能对一个自驱体的行为有判断权，那么你会认为它是自己的一部分。例如董事长视公司，部分父母视孩子。（自驱体：能自我驱动前进的存在）
### 总述
生成基于输入、短期记忆、长期记忆、噪音。
判断基于生成、输入、短期记忆、长期记忆、噪音、意识。
智能函数定义为：生成一个动作，判断，判断通过则执行（不通过则无视），然后将上述过程加入短期记忆。
注：
- $F(输入，记忆)=噪音$ 
- $F(记忆)=意识$ 
### 收敛性
连续多次生成相同的动作且都判断通过时，才会表现为执行。
本质：生成动作，判断通过，执行一帧，下一帧否决，表现为没动。
### 不可察觉性
生成判断的过程难以察觉。只有大量重复的生成判断才可以被察觉。
有人说【我根本没想那么多】【只有你才会一直否定自己的想法，我从来不否定】。这不构成对生成判断的反驳。
案例：
- 解压视频解压，本质是你过去生成过暴力的想法、抑制（可能在0.01秒内），如今释放。你很难察觉到那0.01秒内被抑制的念头。
### 快速性
生成判断的过程是快速的，每秒万次。
### 不负责性
生成是不负责的。大敌当前你很可能生成吃火锅的念头（一秒万念，啥想法都有），甚至一些偶然的情况下、吃火锅的念头可能大量重复得足以被意识察觉。
判断是不负责的。每秒都有大量的判断是矛盾的（同样的生成，不同的判断）。通过收敛来行动。
收敛：对于一个短期目标，矛盾通常会越来越少，最终收敛为【连续多次生成相同的动作且都判断通过】。
收敛通过【生成判断每帧执行。生成判断基于短期记忆。生成判断本身影响短期记忆】实现。
### 检查性
当判断通过时，会进行检查。检查是生成判断【理由XX能否否决此生成】。
通常检查三次。如果在同时做其他事情，那么改为检查一次。
案例：
- 煽动。我说我们能实现X，如果质疑A，那么不成立；如果质疑B，那么不成立；如果质疑C，那么不成立。因此我们必然实现X。那么你会认可X并热血。因为你的检查是检查了ABC。（前提是你不存在比ABC更高生成权重的其他否决理由）
- 错乱。当你思考一个其他问题时，更可能说出来“饺子，帮我把妈拿过来”这种错乱的发言。因为你的检查少：生成饺子，通过，检查通过（要饺子吗？要），生成帮我把，通过，生成饺子，否决（说过了），生成妈，通过（说过吗？没说过。要找妈吗？要）。
- 争论。争论时检查的通常是【我现在认同这个观点吗】【我这样说的话，对方会被我说服吗】。（这个过程不需要意识。有的人是有意识的检查，大多数人是无意识的检查，无意识不意味着没检查、因为他们会说出【自己不会践行、但不反思时不认为自己没践行，且此处说服力强】的发言。）
### 逐层下降性
如果你一直无法收敛，那么会降低判断标准、更倾向于通过。
案例：
- 愤怒，否决，愤怒，否决，愤怒，否决，愤怒，通过。（不自律）
- 做A，没意思，做B，没意思，做C，没意思，做A，没意思，做B，行吧。（躺平陷阱：不要以为你已有的东西无聊后会去找新东西。你不会去找，你只会降低标准、继续玩已有的东西）
### 联想性
生成基于对输入的联想。
判断是【理由X能否否决Y】，也是基于【能否联想到一个场景：理由X否决Y】。
### 插入干预性
生成判断可以被插入所干预。
插入：短期记忆中突然出现一个新条目。短期记忆不都来自于【将生成判断加入短期记忆】。
案例：
- 情绪。愤怒等情绪是插入的。
- 梦境中可以插入强烈的情绪，只对小事。例如，做梦时觉得自己发现了一个了不得的定理，强撑着走到桌子前写下来。第二天醒来一看：香蕉要扒皮才能吃。
### 集群性
众多的生成判断可以组成宏观结构，例如：
- 预测器：在一组生成判断之前，预测最终将执行的结果。（惊讶来自于违背预测）
- 解释器：当否决时，给出否决的理由。
- 念头器：允许生成念头，而非动作。
- 注意力：关注某一个短期记忆，使其不被遗忘。（短期记忆数毫秒内就会遗忘）
解释：
- 主动预测器：否决一切【预测】之外的生成。
- 被动预测器：生成行为A，否决，生成不会出现某状态，赞同，生成A，通过。（预测了不会出现某状态）
- 解释器：同生成大量判断，70%否决30%通过，且不收敛。此时倾向于生成【为什么否决】。（单帧倾向，但等价于持续倾向）
- 念头器：生成喉咙动作（对于哑巴，是生成手语动作），在同意后立刻否决，从而仅行动一帧、无实际行动。
- 记忆注意器：不断生成【是A吗？是。是A吗？是】。
- 关注注意器：否决与A无关的生成。即，围绕A生成众多想法。
案例：
- 梦境的人不会惊讶。要找鞋子，即便自己瞬移了也没有惊讶、继续基于新位置找鞋子。因为梦境时意识强度极低，更倾向于通过（而不是否决），而预测器依赖于否决，因此预测失效。
- 人只能大约同时记忆六个数字。这是因为六个数字需要不断生成来维持注意，即【是A吗？是。是B吗？是。……是A吗？是】。间隔越多，越容易遗忘。
### 普世性
生成判断适用于所有人。
案例：
- 【按压塑料气泡的视频解压】适用于大多数人，【如果经常生成X并迅速否决，那么看到他人合理的做X时解压】适用于所有人。

批评：心理学对AGI无意义。你基于心理学而研究AGI注定是失败的。
回应：心理学对AGI的确无意义，因为心理学中的众多理论是适用于大多数人，而不是所有人。只有适用于所有人的理论，才对AGI的研究有意义。
但是，我不是学习心理学，我是研究心理学，我的理论超越现代心理学，我的理论适用于所有人。