### 基本信息
作者：执悲今厄
修订：仙世凡生
时间：2024.9.11
### 摘要
问：行为树如何迭代为AGI？
答：三层。行为树，心理学表象，生成判断。
从行为树到心理学表象，是选择一个心理学定律，对两种行为树NPC合并。
从心理学表象到生成判断，需要突破口。等大量第二层AI之后再说。

问：有没有可能，第二层就是极限，不可能到第三层？
答：没可能。理由见下。
### 关键词
#关键词/生成判断机制 
#关键词/痛苦遗忘机制 
#关键词/反馈机制 
#关键词/模仿学习机制 
#关键词/分类能力 
#关键词/天赋 
### 前言
本文来自对内部课程的整理。（或者说：对一篇本该是非公开文档的大众化重制。）
本文重制的不够彻底，读者读起来可能有一些别扭。请做好心理准备。
### 引言
背景常识：
行为树是完全先天，AGI是完全后天。参考：[[行为树如何实现动作社会]]
迭代思想：不断削减先天，增加后天，保持效果不变。参考：[[行为树如何实现动作社会]] 内觉迭代法
### 后天：性格来自反馈
习题：使用行为树来定义一个勇敢的NPC矿工、一个胆小的NPC矿工。勇敢的会在遇到海盗时倾向于战斗，胆小的会倾向于逃跑。
答案：略。不会做的话问我。

基于这两个NPC，使用如下逻辑改动：
- 无经验时，NPC面对海盗，会随机行动（战斗或逃跑）
- 行动时：如果战斗并胜利，那么战斗权重+1。如果战斗并失败，那么逃跑权重+1。如果逃跑，那么逃跑权重+1。
- 有经验时，NPC面对海盗，会基于权重而随机行为，其中随机行为权重1。例如，战斗权重10，逃跑权重1，随机权重1，那么有10.5/12的概率战斗，1.5/12的概率逃跑。
这样，就是【削减先天，增加后天，保持效果不变】。

问：这不是人脑算法啊，人脑中不可能存在【权重】这个东西。
答：
第一，注意，我说的是：逐渐削减先天、增加后天。逐渐接近人脑。而不是【直接得到人脑】。我上面的逻辑相比于经典行为树，更接近人脑。
第二，人脑算法需要基于生成判断。人脑是：正面经历作为生成素材与判断通过素材，负面经历作为生成素材与判断否决素材，决策时生成判断。
顺便一提：人脑的这个算法，也可以解释如下两个东西：
1.越错越做。你知道X是不对的，但越讨论X、未来就越做X。（因为负面经历作为生成素材。虽然也否决，但没有其他强的Y来取代X，导致基于逐层下降机制而通过X。逐层下降机制：如果一直无法通过，那么降低判断标准。另外：这也描述了【越做越错】的范畴：范畴是【其他强的Y来取代X】时。）
2.【痛苦遗忘机制】：强烈的痛苦会立刻遗忘（连带着周围的其他记忆），一般的痛苦也会遗忘。（因为不遗忘的话，负面经历会作为生成素材，干预决策。）
### 后天：能力来自模仿
习题：使用行为树来定义一个聪明的NPC矿工、一个愚蠢的NPC矿工。聪明的会使用镐子挖矿，而愚蠢的会徒手挖矿。镐子会磨损、损坏后重新买。镐子从市场购买，钱不够则卖矿。在基地执行【购买 某道具 某数量】是原子动作。（原子动作：对调用方而言无需定义，视为一个最小原子、买道具如同打响指一般简单）
答案：略。

基于这两个NPC，使用如下逻辑改动：
- 无经验时，徒手挖矿
- 如果看到别人挖矿，那么预测对方获得的矿物数量范畴。初始预测基于自己挖矿的历史。
- 如果对方获得的矿物数量不在自己的预测中，那么尝试解释。解释的格式是【记忆中：满足X性质的人开采的矿物数量多/少】【观察发现：他满足X性质】。如果无法解释，那么提取他的一些独特性质，以【满足X性质的人开采的矿物数量多/少】的格式加入记忆。如果能解释，那么强化记忆（权重）。如果在预测中，那么强化记忆（预测基于性质。初始预测依赖的性质视为【他是人】）。
- 如果记忆中有【满足X性质的人采矿多】且自己不满足X，那么尝试去满足。尝试的方式是【记忆中有：要满足X，则执行指令A】。如果尝试失败，那么预测【某个不满足X的人是否会满足X】，预测基于【他过去短期内是否满足过X；他现在是否不满足X】。当预测到某个人会满足X时，观察那个人执行的指令，在记忆中添加【要满足X，则执行那个指令】，直至那个人满足X、或长期不满足。
- 偶尔整理记忆。整理：寻找互斥项；对于悬殊的互斥项，删除弱者。

问：比这个更底层的人脑算法是什么？
答：还是生成判断。模仿是因为获得了生成素材。因为这样的生成非常不稳定，所以真正的模仿必须伴随着矫正：
- 可以是教师在你模仿错了的时候批评；
- 可以是你模仿时不断观察对方、观察自己、时刻思考【我的是否和他不一样】、从而错了的时候自己发现、自己批评；
- 可以是你看过一遍之后自己在模仿时回忆、自我批评。
不过生成判断太底层了，写的话很麻烦，因此前期的迭代不使用生成判断，而是使用本文演示的这两个案例这样的【心理学表象】。
即，AI的迭代至少三层：
- 第一层：先天AI。行为树定死的AI。
- 第二层：心理学后天AI。本文这两个案例这样的，有一定的后天能力，但是按照心理学的格式固定。
- 第三层：生成判断后天AI。完全生成判断的就是AGI。
大量的第一层简化为第二层，大量的第二层简化为第三层。

问：第二层只有本文这两个吗？
答：当然不是。第二层非常多。你翻翻心理学教材，每一个定律都可以写成一个第二层的AI。
我们文章软件里写过的【社会促进效应】【动机】【学习机制（愉悦）】【官职感（学习机制）】【基于忽视的爽感（学习机制）】【帮助与感谢】，每一个都可以设计一个第二层AI。

问：后天AI能否合并？例如，让一个AI拥有反馈机制与模仿机制。
答：可以且最好。这样不需要写那么多AI，只需要写一个第二层AI、添加大量的小机制。（并把这个AI算法复制给众多NPC）
即，写大量不同的第一层AI。然后写一个有着大量不同细节机制的第二层AI。然后写一个有有限机制的第三层AI。
### 从第二层到第三层
问：如何从第二层到第三层？
答：你先把第一层到第二层消化了再说。

问：我希望提前了解，提前让潜意识思考，以表现为【在迭代AI方面的天赋提高】。
答：找案例麻烦。需要找到合适的案例作为突破口、低阶的接入生成判断。我相信这样的案例是存在的（毕竟我研究生成判断的历程就是从低阶到高阶），但我遗忘了我早期研究的原始素材，所以我现在没法给你举例讲解二阶到三阶。但当我们写出大量的二阶之后，我能从中选择出合适的突破口来进入三阶。
突破口可能是【创新一种厨具（通过生成判断来构思创新）】或【构思象棋残局解法（见于：大征西）】。但我现在不想思考这个问题，这个问题涉及的东西太多，要回答的话、一篇文章都打不住、估计要三五篇。

问：有没有可能，第二层就是极限，不可能到第三层？
答：没可能。生成判断有大量的性质与辅助定律我都已经在中文上明确，并且突破口也必然存在（复现我的研究历程就可以）。
而且我分类能力也强。超过六个在同一领域之下的项放在同级，我必然能通过标准描述+抽象归类来得到至少两个上级。参考：分类能力。超过六个第二层的，我必然能将其结构化分层；不过分层的结果未必得到第三层，而是可能是稀疏树（例：石头、鲨鱼、河马，构成的物质-生物树，就是稀疏树），第二层进入第三层的话需要对大量第二层进行密集分层（第一层进第二层也是依赖于密集。胆小矿工和勇敢矿工是密集的、类似于人和猩猩）。
### 总结
问：行为树如何迭代为AGI？
答：三层。行为树，心理学表象，生成判断。
从行为树到心理学表象，是选择一个心理学定律，对两种行为树NPC合并。
从心理学表象到生成判断，需要突破口。等大量第二层AI之后再说。