### 产品介绍
《风神界》，玄幻战略RPG游戏，单机买断制，全球发布。
风神界，是一个由AI驱动的、庞大的沙盒世界，玄幻世界观。整个世界即便没有玩家，也可以自发运转，王朝更迭。
上万位面，百亿NPC，实时演算。开局，玩家以凡人的身份穿越到风神界。没有剧情，没有任务，完全自由。
玩家可以独行RPG、浪迹天涯、以探索秘境为乐趣，也可以建立势力、战略争霸、以征服天下为目标。

我们的游戏有诸多亮点：
- 算法强大。虽然世界宏大，但可以在家用电脑运行。开局只有十万名具象NPC，其余百亿名NPC以【NPC们的地区/资金/境界分布特征是怎样的】的抽象形式存在，当被玩家观测到时具象化（随着游戏进行，具象NPC数量会达到二十万左右）。
- 世界观集玄幻万家之所长，无数精妙的设定、恢弘大气，乃中国玄幻的大乘之作，可让世界领略中国玄幻的想象力。
- 数值合理，在境界等级森严的同时令高阶修士无法灭世、令势力有存在的意义；人数合理，避免【后期圣阶多如狗】的情况。
- 沙盒世界，即便没有玩家、世界也能自我运转、王朝更迭。这赋予玩家真正的自由感、穿越感，而不是剧情游戏那样的束手束脚。
- 经济学。所有物价都由玩家或NPC决定，游戏设计师仅通过调整供给与需求来暗中操控物价。
- 社会学。玩家与NPC后天分工，玩家只需要体验游戏中的一个子集、就足够有趣。玩家总可以获得新鲜感。
- 政治学。尔虞我诈乃家常便饭，玩家要对抗下属的恭维蒙蔽、反叛者的隐瞒、敌人的欺骗；每一个势力的历史都可以写成一本波澜壮阔的小说。
- 心理学。NPC通人性。单机版要想实现【经济学、社会学、政治学】，必须要优秀的NPC AI设计。另外，为了节约算力，我们会使用行为树（而不是大模型）。
### 世界观
境界划分：凡人、炼体、通脉、开窍、炼气、筑基、金丹、元婴、化神、炼虚、合道、大乘。
炼气以下皆蝼蚁。炼气为仙师，可隔空杀人、御剑飞行。
金丹为大能，寻常宗门宗主即为金丹，可以参与上层社会的各种大典。可以破碎虚空，拥有诸多保命法门、几乎不会陨落。
元婴为一流势力宗主级别，如地府阎王、丹宗丹王。
化神者，诸天万界仅十人左右，圣地之主，甚至有的圣地之主仅元婴级别（十二圣地）。化神者可以掌天机、逆因果。
炼虚，大帝。通常情况下，同一个时代仅有一名大帝，大帝在他的时代无敌。寿元三千载。
合道，圣人。身融一界天道，不死不灭。圣人于界内无敌、可一念断人生死，圣人所在的位面为圣地。

风神界，通常是指以风神界为中心、加上诸天万界的整体。
风神界历史百万年。每十万年有一次合道机缘（天道轮回破缺）、可令一人成圣。加上原初天道与深渊意志，共十二圣人。
昔年那些寿元将尽的高阶修士（金丹以上）会自我封印、等待大争之世到来之时苏醒。
平日里万界之中通常只有一名炼虚、十名化神、百名元婴，而在大争之世中苏醒的炼虚有三十多名、元婴三万多名。他们将燃尽最后的寿元，激烈的交锋，缔造璀璨的时代，最终的赢家将进阶合道、成为圣人。

在游戏中，玩家可以看到许多上古修士的遗迹，其中有对大争之世的准备、也有大争之世的交锋，例如：
- 两个炼虚大帝的大战会打得一个位面赤地千里、寸草不生，在一些小位面甚至打得时空破碎、化作千万时间碎片、流传百万年。
- 高阶修士寿元将尽、自我封印之时，会将全部身家带在身边，并且在周围布置凶阵、养殖凶兽、设置诅咒，将一片地区化为凶险禁地，从而保护灵棺渡过万年。玩家可以看到许多这样的凶地，并可以尝试去探险、盗墓。

十二圣人：
- 原初天道：下辖平等圣地。混沌初开，天地之主，无欲无求。建立平等圣地，平等圣地内禁止杀伐，凡人也可安居乐业；这里也成为了贸易中心。
- 深渊意志：下辖深渊。混沌初开，深渊之主，入侵万界。深渊恶魔会无限繁殖，以入侵来消耗人口。
- 风神：下辖风神界。第一位合道圣人，创建功法灵技，终结了武道时代，开启了修真时代。
- 剑圣：下辖剑灵界。第二位合道圣人，创建心法，终结了【唯境界论】的时代。
- 魂圣：下辖魂界。第三位合道圣人，创建魂格，使得修士可以拥有第二第三条命。如今魂格是所有修士的必修课。
- 雷神：下辖雷火圣地。创建神格，使得天才的天赋可以被一定程度的窃取与保留。如今各种神格是各大势力的底蕴与镇宗之宝。
- 阵圣：下辖七星圣地。发扬阵法，创建护山大阵，可以跨越二阶来防御入侵，终结了【修真者皆魔】的乱世，开启了势力时代。
- 咒圣：下辖幽冥圣地。发扬咒法，无视护山大阵；创建秘术，如今自爆与燃烧都是修士必修课。
- 无双神：下辖无双界。异族。发明灵石的诸多新用法，其中吞灵术最关键，可以战斗中大额消耗灵石、迅速恢复灵气，是当代高阶修士必修课。
- 神帝：下辖神教。发明魂通，统一功法灵技心法魂法神格等外力，重塑外力体系。发明元法：一种针对外力体系本身生效的术法。如今神道难练，但神道修士强于其他修士。
- 雅圣：下辖大雅帝国。帝国之主，成圣之前就已经征服天下，各种战略方法被后世所学习与模仿。
- 魔圣：下辖魔教。散修，发扬结界与遁术，成圣之前曾屠杀众多宗门。
每局游戏的历史随机生成，开局演变百万年；但十二圣人必然是这十二人。证道成圣者，无古今之分；圣人超脱时间长河，不死不灭，在历史、现在、未来同时成圣。
（开局演变时，所有NPC与地块都是量子态。当某个区域的波动强度足够大时，坍缩为具象态。百万年后，大约会形成几万个具象地点（遗迹或秘境）、十万个具象NPC，万界百亿人绝大多数依然是量子态的，此时玩家进入世界。每个具象地点都有完整的史书记载其历史，每局独一无二。）
### 竞品分析
**EVE Online**
EVE是一款星际战略RPG游戏，网络订阅制，全球发布，盈利两百亿。
这是一个庞大的沙盒世界，包含上万个星系。百万玩家同服，演变二十年，无数势力的兴衰灭亡。
EVE最强的特点在于政治斗争与阶级剥削。甚至，游戏内的剥削蔓延到现实，大型势力盟主会要求全体成员绑定ESI，对成员电脑进行全方位监控、包括QQ与微信的消息记录，用于排查间谍。但因为政治斗争的史诗感、玩家甘愿绑定ESI自证清白。
EVE饱受赞誉，各大奖项拿到手软，被誉为【游戏鄙视链顶端的存在】【这不是游戏，这是一场超大型社会实验】【第二地球】。因为EVE包含了经济学、社会学、政治学。
- 经济学：一切道具都由玩家们产出与交易，贸易中心每天交易量数百万单，上万种道具可以自由贸易、有K线图，顶级的玩家单凭金融手段就可以在游戏中月入过万。（经济学游戏物价稳定，游戏币可以淘宝交易为人民币）
- 社会学：数百种职业分化，并且职业是后天的，官方不规定职业、玩家自发形成职业。许多玩家即便玩了十多年，依然对很多游戏内容不了解：工业家不需要关注刷怪内容，只需要知道那些刷怪玩家会给市场带来魔兽材料就够了；甚至都不需要关注市场中的那些东西是怎么生产的，只需要知道市场上有、知道价格走势，就够了。
- 政治学：EVE中每一个势力的历史都可以写成一本波澜壮阔的小说。国服最耀眼的当属PIBC。PIBC鼎盛时期占据天下半壁江山、并限定其他势力的领土不允许超过一个星域（PIBC数十个星域，从而其他人无法威胁PIBC），要求其他势力每月对PIBC朝贡。但如此强大的PIBC依然亡于内部分裂，各大军团夺权、间谍战、尔虞我诈、勾连外部势力，精彩程度不亚于康熙九子夺嫡；其他势力也没闲着，在明面领土不超过一个星域的前提下，在PIBC党支部植入每个势力的前提下，硬生生的形成了一个暗中的八星域联合体，在PIBC分裂之际强势崛起并给予其致命一击。
但是，剥削终究是令人不爽的。不只是ESI，EVE中各大势力还有高昂的赋税，包括比例税、人头税、战役税、运输税等，还有极限集结期间的百分百税率：极限集结期间，玩家只能参与战役集结，否则一切其他活动都没有任何收益。更要命的是三天两头就要极限集结一次，因为敌方势力发起了极限集结的进攻、我方不得不极限防御。各种税加起来让底层玩家光是维持住身份就已经筋疲力尽了；大量的玩家选择加入一些没有税务压力的小型势力来“养老”，但也因此远离EVE的中央舞台，只能在贫瘠的星系中活动。
EVE的缺陷的本质，在于它是一款网络游戏，必然大多数人扮演底层。而我们的游戏是单机的，NPC可以作为底层，从而让每个玩家都能体验到上层社会的权力感。

**KenShi**
KenShi是一款废土战略RPG游戏，单机买断制，全球发布，盈利两亿。
这是一个庞大的沙盒大陆，绕大陆跑一圈需要一个小时。数十个势力，上千个城池或小型定居点，数万个NPC自由活动。
玩家作为一个普通人进入这个世界，你的第一个目标是活下去。你可能面临饥饿、野兽、杀人强盗、奴隶贩子。
当你有了一种谋生方式、能够活下去之后，你可以开始尝试买房子、练武冒险，甚至偷东西、走私货物。
当你有了大量的资源后，你可以开始招募伙伴，建造城池，建立势力。可以与其他势力外交，宣战；可以内部建造建筑、发布指令。
最终你让天下臣服，并且灭掉各个遗迹、集齐所有宝物。你开始空虚，但回顾过去，你已经拥有了一百小时的开心经历。
KenShi的缺陷的本质，在于AI太蠢，而且经济不平衡。物品的价格是固定的，NPC的货币是每日刷新的，这导致玩家可以大量制造产品后卖给NPC、轻松刷钱，后期很容易无敌。
KenShi的战略部分很空洞，远不如《文明》《群星》之类的游戏。它归根结底还是一个RPG游戏，EVE才是真正的战略RPG游戏。
我们的游戏也会是一个真正的战略RPG游戏。那需要经济学、社会学、政治学、心理学知识。
### 数值设计与营销
**封装营销设计**
传统的游戏开发，营销方面需要解决两个问题：1.让玩家知道你的游戏。2.让玩家想玩你的游戏。为此，演变出各种高级营销手段。
我们的游戏不需要那些高级手段，可以使用一个朴素的办法解决这两个问题：自媒体。
我们有一个最终效果设计稿，游戏做完之后按照这个稿的节奏去录一个视频、我们有70%的把握可以千万播放、95%的把握至少百万播放。之所以这样确信，是因为大量的自媒体经验、对数十人的采访调查、以及王老菊的《奴隶阿飞的励志人生》视频先例。
- 效果稿：[[虚拟宇宙游戏节奏]]。
- 自媒体经验：团队中有很多人做过自媒体，目前有八个有单图文万赞或单视频百万播放的账号。
视频引流量大约是5%。游戏单价100，千万播放的话，单视频就可以带来五千万的收入；再结合其他途径（Steam推荐、论坛口碑传播），总收入过亿没问题，甚至可能十亿百亿。
**封装数值设计**
传统的游戏开发，数值的平衡与反馈是一个难点，除非投入市场验证、否则你很难证明你的数值是好的；如同黑屋洗衣服，你很难证明你衣服洗干净了。
但我们的游戏提供了一种验证数值的方式：沙盒运转。
只要这个无玩家的沙盒世界能稳定运行，不会出现【高阶修士大肆屠杀】【阶级固化】【阶级混乱，高频率地被跨越】等不正常现象，且经过测试后没有【玩家可以迅速升级/刷钱】等漏洞，那么数值就是完美的：毕竟，NPC都能成圣，你玩家难道还会不行？
基于此，我们不需要考虑那些传统的数值设计理论，只需要有基本的数学思维常识就够了。并且我们有基本数学思维：
- 原创游戏数值设计文章（知乎三万赞）：https://www.zhihu.com/question/408047091/answer/1354528087
- 未发布到第三方论坛的优秀文章：[[从超级扫雷的数值设计看数值设计师所需的能力]] 
- 未发布到第三方论坛的优秀文章：[[风神界：境界人数与寿元]] 
### 开发计划
- 2022.09.30：官网发布，用户可以提问题、读文章。用于学习编程，打通前后端技术栈。（已完成）
- 2022.12.30：官方软件发布，用户可以使用软件提问题、读文章。用于学习C++ Windows编程技术。（已完成）
- 2023.03.30：完成《风神界》的大量碎片，包括移动、攻击、采集、食用、装备、购物等；基于Unity，学习了渲染、动画、3D、数据库等各项技术。但意识到缺乏一个系统的架构来串联碎片。（已完成）
- 2023.06.30：官方软件2.0版本发布，使用Unity重构客户端。并且基于Unity制作前端库，包括目录树、选项卡、右键菜单等，拥有一个两万行的、系统的、代码优雅的、原创的前端库。（已完成）
- 2023.09.30：完成内部软件，以话题为单位进行交流，便于回看历史、搜索、整理。（已完成）
- 2023.12.30：完成游戏《方案之困》，一款挂机战斗小游戏。用于研究游戏架构。但未发布，因为前期数值与新手引导有问题，写了好几份研究文档、改了好几版设定也没解决。而且由于我们设定庞大，每一次改动数值都很高成本。（已完成。架构已清晰，有五万行的原创前后端全架构库，可以基于此架构、通过填充一个个模块来量产游戏）
	- 相关资料：[[游戏研究：挂机游戏好玩的本质是什么？]] 
	- 相关资料：[[如何设计地图使得地图能够让玩家钻研]] 
	- 相关资料：[[游戏研究：从CPU看角色设计]] 
	- 相关资料：[[游戏设计：强度系统划分]] 
	- 相关资料：[[游戏设计：论游戏节奏中的速度]] 
	- 相关资料：[[方案之困：游戏简介]] 
	- 相关资料：[[项目：游戏流水线]] 
	- 相关资料：[[风神界：流派与时间碎片]] 
	- 除了上面的通用研究文档之外，此外还有上百张专用设定表，五千多个具体的专用道具设定，十多个专用数值总纲表，十万字上百节的专用背景故事。
- 2024.03.30：重构游戏《方案之困》，原创设定编辑器，使用公式来生成设定表，基于编译原理、使用表达式树来解析设定表（我们允许列为字符串描述的函数），用于低成本修改数值。但依然改不好数值，于是计划做一款轻量级游戏研究数值。（已完成）
- 2024.06.30：发布游戏《超级扫雷》，一款轻量级游戏，精心研究了数值设计，但体验还是一般（比方案之困好）。我们对此进行了深入反思，意识到是新手教程与bug的问题，这会在二代中改进。（已完成）
	- 相关资料：[[从超级扫雷的数值设计看数值设计师所需的能力]] 
- 2024.09.30：发布官网2.0版本，包含商业计划书、更新日志。参与数十场会议，迭代商业计划书写作方式。（已完成）
- 2024.12.30：发布软件3.0版本，基于原创的类EVE选项卡UI架构、融合了内部软件与公开软件，引入权限管理。（已完成）
- 2025.03.30：发布游戏《超级扫雷2》。计划：验证新版数值设计与新手教程理论。单价10元，预计评价一千、销量三万、收入三十万。
	- 具体规划：[[超级扫雷二代：任务模式]] 
- 2025.06.30：发布游戏《风神界：战斗》。挂机战斗游戏，基于方案之困。为风神界提供战斗系统的库。单价30元，预计评价一千、销量三万、收入一百万。
- 2025.09.30：发布游戏《风神界：建造》。生存建造游戏，类似异星工厂。为风神界提供2D系统的库。单价30元，预计评价一千、销量三万、收入一百万。
- 2025.12.30：发布游戏《风神界：战略》。战略管理游戏，类似钢铁雄心。为风神界提供战略系统的库。单价100元，预计评价一千、销量三万、收入三百万。
- 2027.12.30：发布游戏《风神界》。核心游戏，单机虚拟文明游戏，类似KenShi。单价100元，预计评价三万、销量百万、收入一亿。
	- 相关资料：[[虚拟宇宙游戏节奏]] 
	- 具体规划：[[风神界游戏开发：里程碑]] 
- 2031.12.30：发布游戏《风神界：势力永生》。二代核心游戏，网络虚拟文明游戏，类似EVE。订阅每月100元，预计百万订阅、年入十亿；同时带火单机版游戏，加上DLC、私服租赁、交易税与皮肤、局域网联机版，总年入五十亿。
	- 相关资料：[[风神界：大争之世]] 
	- 相关资料：[[风神界：尊敬感]] 
- 2035.12.30：发布游戏《风神界：创世》。AGI，世界政局动荡。算法与公司一起卖给国家，我们退出。
### 风险分析
注：下面提到的【特性】【名著】来自旧版商业计划书：[[《风神界》商业计划书]]。
- [[质疑：这需要的算力太庞大了，不可能实现]] 
- [[质疑：这游戏有人买吗？玄幻题材玩家太少]] 
- [[质疑：这游戏有人买吗？订阅每月一百太贵]] 
- [[质疑：你们团队资历太差。没学历、没经验]] 
- [[质疑：特性没用。你们游戏设计能力不专业]] 
- [[质疑：你们会遇到技术问题]] 
- [[质疑：你们会遇到管理问题]] 
- [[质疑：你们会遇到营销问题]] 
- [[质疑：名著？狂妄。]] 
### 股权结构与董事会成员
股份：CEO70%，创始团队10%，期权20%。本轮投资人从期权中拿10%。
董事会不按股份来表决与分红，股份仅用于法律象征。具体董事会经济与决策模式过于复杂，此处略，只表达几个性质：
- 不影响投资人权益。分红时优先将投资人与期权的部分划分出去，之后对剩下的按董事会内部流程处理。
- 虽然轻易不会使用，但CEO拥有最高决策权。（不只是法律上，也是董事会内部流程上）

董事会成员，平均每人每天核心工作时间3小时，探索时间9小时（包括交流、会议、学习、思考），洗漱吃饭健身3小时，睡眠9小时。
- 执悲今厄：男，24岁，高二停课。冷静理性。目标是通用人工智能、永生、机械改造、遨游星海。
    - CEO，负责对接所有人，协调所有项目、做最终审核，为其他人提供教学。
    - 具备：描述能力、分析能力、学习能力、研究能力、认知心理学、游戏设计能力、小说/文章写作能力、视频设计能力、编程架构能力、教育能力。
    - 高一在北大附中全校第一，高二辍学探索各行各业。三年确定AGI的道路，五年自学AGI所需的各科知识。
    - 做过的盈利过万的项目有：高中奖学金、影视特效开发、导游、心理咨询、百度贴吧偷星九月天吧吧主官方经费、写作教程打赏收入、知乎引流荔枝微课学习方法付费专栏。专栏收入六十万元。
    - 对董事会其他成员长期教育，使其他人都拥有媲美CEO的学习与研究能力。教育方法主要包含三个要点：
		- 无限展开。我能对任何一个知识点无限层的展开，学生对任何一个点不理解、我都可以详细讲解。不会说【笨！这不显然的吗？这你都不会？】。特别的，展开有两个技巧：案例化、低阶化。案例是指举例子，低阶是指【如果不用它，那么可以用哪个其他的东西、实现凑合但有缺陷的效果】。
		- 因材施教。我曾研究过小说人物塑造，也因此了解万千人性分类、并拥有强大的代入能力，能够随着与学生的熟悉而无限深入的理解学生的能力与性格，并基于此来给每个人定制课程。
		- 梯度化。这是教育的核心，我会让学生从解决一个小困难开始，不断解决越来越大的困难，平滑上升，直至强大。我能敏锐察觉到每个学生的状态，随时调整任务难度、提供帮助、修改后续任务计划。如此数年，直至他们成长得：绝大多数难题他们都能自己解决；那少量的他们难以解决的困难，我解决起来也不简单。
- 千里未来：女，24岁，大二退学。开朗但有所保留、心思多。目标是维持现状：有热闹的团队、工作有价值而不累。因为团队不断进步，所以维持现状需要个人不断进步。
    - 首席游戏设计师，负责游戏的玩法设计、数值设计、视频效果稿设计。CEO的高中同学，2015年认识，2020年加入团队。
    - 接受CEO的教育，如今具备：描述能力、分析能力、学习能力、研究能力、认知心理学、游戏设计能力。
    - 在Steam玩过数百款单机游戏，提炼游戏优缺点并自洽化，有原创游戏设计理论。诸多理论在书籍中印证。（印证：先原创，再读书时发现书上的内容和自己原创的一致，有时超越或不如原创的）
    - 资深EVE玩家，多开十余个账号、体验全部职业、参与重大战役、见证许多军团的兴衰灭亡，曾在EVE中使用金融手段盈利数万元（EVE游戏币可以淘宝交易为人民币）。
- 暮已归人：男，20岁，初中毕业。略自闭。目标是沉浸在虚拟文明游戏中体验。（上级：在地球掌权。下级：想象自己在虚拟文明游戏中）
    - 世界观设计师，负责游戏的世界观设计、细节设计。CEO的贴吧粉丝，2017年认识，2020年加入。
    - 接受CEO的教育，如今具备：描述能力、分析能力、学习能力、研究能力、认知心理学、小说节奏设计能力、玄幻世界观设计能力。
    - 读过数百部玄幻小说，书写过数十万字的世界观设计稿。擅长拆解他人作品的大纲与设定。
- 浊浪逝风：女，31岁，本科毕业。外冷内热。目标是远离浑浊的社会、寻求内心的宁静。
    - 认知心理学顾问，负责提供认知心理学教学、回应对AI NPC设计的咨询。CEO的知乎粉丝，2019年认识，2020年加入。
    - 数学与金融专业，原单位月薪过万。接受CEO的教育，如今具备：描述能力、分析能力、学习能力、研究能力、编程能力、认知心理学。
    - 有数百篇原创人脑原理理论文档，分析了经济学、社会学、政治学中众多的人类行为现象背后的心理本质。
- 仙世凡生：女，22岁，高中毕业。天真，勤快。目标是参与一个划时代的项目。
    - 运维负责人，负责官网更新日志、多平台同步更新文章视频、游戏的申请与打包与更新等杂务。CEO的知乎粉丝，2019年认识，2020年加入。
    - 接受CEO的教育，如今具备：描述能力、分析能力、学习能力、研究能力、认知心理学。
    - 与十余名已财务自由的游戏开发者保持良好关系，当风神界发布时可以在他们的粉丝群（不低于千人）中以群公告的形式宣传。
- 天涯剑歌：男，28岁，本科毕业。爽朗。无目标：荣华富贵喜欢，机械改造也喜欢，一无所有也接受。
    - 编程架构顾问，负责提供编程与编程架构教学、回应对编程架构的咨询。CEO的一名知乎粉丝的朋友，2021年认识，2021年加入。
    - 接受CEO的教育，如今具备：描述能力、分析能力、学习能力、研究能力、认知心理学、编程能力、编程架构能力。
    - 独立或主持开发众多程序，包括各代官网与内部软件。使用并开发过完整项目的语言有HTML、CSS、JavaScript、PHP、MySQL、C/C++、QT C++、VS C#、Unity C#、Python。
- 忘忧草：男，19岁，高二退学。常大喜大悲，但可瞬间严肃。目标是被认可、不被他人掌控命运，追求金钱权势。
    - 注资者，独立开展变声器项目，当前月入四万元。CEO的知乎粉丝，2021年认识，2022年加入。
    - 接受CEO的教育，如今具备：描述能力、分析能力、学习能力、研究能力、认知心理学、编程能力、视频设计与制作能力。
    - 拥有闭环级的工程与研究能力，工程是指从软件开发到营销，研究是指从分析到反馈修正：三个月研究视频制作理论，发布视频一百播放；修改理论，第二视频一万播放；修改理论，第三个视频百万播放，此后稳定十万播放以上。
	    - 视频制作理论的得出，是先观察众多视频、提炼其优缺点，再自洽化、精简化。
	    - 自洽化：例如，【优点：有主见】【缺点：不守规矩】，这是一种矛盾：有主见就是不守规矩，它不能既是优点又是缺点。需要改为：【优点：规矩错误，不守规矩，有主见】【缺点：规矩没错，不守规矩，招人烦】。
	    - 精简化：例如，【优点：规矩错误，不守规矩，有主见】精简为【优点：观众知道应该做某件事，但又有心态上的理由而不敢做那件事，此时主角做了那件事，观众会震撼与兴奋】。精简后虽然字数多，但可以统一数十条精简前的优点。
- 伊利菌：男，20岁，大一休学。内心赤诚，但不会与理性者打交道（在学）。目标是做出伟业，名垂千古。
    - 编程工程师，负责具体编程。CEO的知乎粉丝，2020年认识，2022年加入。
    - 接受CEO的教育，如今具备：描述能力、分析能力（难启动）、学习能力、研究能力、认知心理学、编程能力。
    - 参与众多程序的开发，包括官网、内部软件、游戏、变声器。拥有攻坚能力：综合大量资料，解决前所未见的技术难题。
- 看山：男，22岁，大三休学。坚毅。目标是做出光速飞船、遨游宇宙。
    - 论文书写者，负责将其余成员的原创理论修改为论文并发布。CEO的知乎粉丝，2019年认识，2024年加入。
    - 物理学专业。接受CEO的教育，如今具备：描述能力、分析能力、学习能力、研究能力、认知心理学。
    - 拆解过SCI论文、在学校做过文献汇报；书写过大量论文格式的印证文档（印证文档：对于一个已有知识，假设它不存在，我是发明者，那么我如何发明它）。
- 田嘉豪（预备）：男，31岁，单身无牵挂，线下工作。多听多看多做少说。目标不定，接受平凡的生活、但保留对大事业的渴望。
	- 游戏工程师，负责游戏编程。面试者，喜欢项目与团队、希望未来能加入董事会，暂定月薪8000。2024年认识，2024年入职、双向考查，旁听董事会决议且允许参与讨论。（我们考察他，他也考察我们）
	- 在北京解放军总医院有七年全栈工程师经验，原单位月薪税后两万；使用Unity开发过独立游戏。
### 当前进度
技术积累已完成：
- 游戏设计理论：执悲今厄，千里未来。拥有数百篇原创研究文档，囊括爽的本质、玩法创新量产方法、数值设计理论、经济学社会学政治学与虚拟文明游戏的融合。
- 编程知识：执悲今厄，天涯剑歌，伊利菌。开发过论坛网页、单机游戏、联机游戏，拥有一个五万多行的原创代码库、囊括了前后端全栈，原创与印证了诸多编程架构理论。
- 意识理论：执悲今厄，浊浪逝风，看山。拥有数千篇心理学研究文档，拆解了数百个经济学、社会学、政治学中的人类行为案例背后的心理本质。
- 世界观设计：执悲今厄，暮已归人。读过大量的玄幻小说，经常幻想原创世界观，广度与深度都非常丰富。对风神界的世界观设计有数十万字的文稿，还有更多的在脑内。
- 营销：执悲今厄，千里未来，忘忧草，伊利菌，仙世凡生，看山。B站抖音小红书众多百万播放视频，知乎众多万赞文章。

DEMO已初步完成。
我们目前的DEMO，主要表现在AI的自主行动方面。
我们的AI有几个特点：自主生存，听驱不听使，学习与记忆。下面分别介绍。
- 自主生存。将AI放在野外，因为饥饿需求，他会采集果实食用，采集木头搭建房屋，种植农田。当遇到敌人时，会躲在房屋里。
- 听驱不听使。我们控制一个新的角色，对AI提议让他跟我们走，他不听。攻击他、禁锢他，再提议让他跟我们走，他表示会听。解除禁锢后，他会跟我们走，但随时可能逃跑。
- 学习与记忆。我们带着AI来到城市，购买了优质的食物，给他吃。他表示非常开心。然后我们将AI瞬移到野外。AI不再盖楼种地，而是采集了一些食物后就开始四处移动，寻找城市。他记得之前城市中有美食。

后续我们将制作如下特点：
- 后天分工、金融发达。如果一个商人AI的货物被海盗打劫了，那么这个商人可能崩溃之下转行做海盗；如果一个猎魔人AI受伤后发现疗伤药很贵，那么这个猎魔人可能转行学炼丹。大量AI在细分领域工作，通过社会贸易来合作，贸易中心的每日商品交易量数以亿计，价格由市场决定。这又催生出一批投机AI，低买高卖来盈利。
- 王朝争霸、权力斗争。见于[[虚拟宇宙游戏节奏]]。
### 融资计划
融资500万元，出让10%股权。
其中，人员工资350万，场地设备100万，会员专利20万，营销合作30万。
我们会扩招更多的程序员，使用任务模式管理：立项时，执悲今厄对每个项目制定一个全局规划，包含一系列分解任务。项目推进时，执悲今厄对接所有员工、检查旧任务、发布新任务。董事会成员提供执悲今厄需要的资料与任务草案，或直接代为负责对接员工、执悲今厄监督。
如果获得投资，那么我们会砍掉三个风神界小游戏的计划，在超级扫雷2取得成功后直接开始单机虚拟宇宙的制作。
预计：一年完成单机版开发，收入一亿；三年完成网络版开发，收入百亿。

质疑：这速度合理吗？
回应：合理。
首先，单机版合理。我们不只是一年，而是三年，因为我们有两年的积累，各个模块的库都已经比较完善了。
然后，网络版合理。我们的代码结构非常好，单机版也是前后端分离的，可以很方便的迁移到网络版中。
### 联系方式
QQ：1181807822（执悲今厄）
邮箱： 1181807822@qq.com