## 正文
### 学术知识
学术知识是高阶的（比如十阶），需要降为【十阶、九阶、八阶……一阶、零阶】的一个序列，然后从零阶到十阶的发展。这样才符合人脑的学习机制，从而让人学习上瘾。
如果跳过低阶，直接教高阶知识，那么会很枯燥。学校教育就是犯了这一点错误。 
各阶之间是指数关系，而不是线性关系。
线性关系：A分为abc。abc就是线性关系，a、ab、abc也是线性关系。并列与递进都是线性。
指数关系：B与A是指数关系，B是一个看上去与A完全无关的事物。例如，经验医学（中医）与生物医学（西医）是指数关系，教生物医学时、首先需要将它降阶为经验医学（并且还要进一步降阶）。
### 分析案例：编程知识
教编程时，需要对编程降阶。
降阶的方法是：找出编程的核心性质，找出这个性质的弱化版，找出这个弱化版所对应的具象，将编程降阶为该具象。
编程的核心性质不是描述，而是优化（重制），是【耦合、可优化（去耦合）】，弱化版是【无耦合（但X）、可优化（去X）】，具象是【无耦合但庞大且冗余、可优化（精简）】，进一步具象是【像异星工厂一样，对基于“合成公式、组装机、传送带、建筑占据空间”而庞大冗余的工厂优化】。
即，编程的教育方式是【先以合成为主、让玩家设计大规模工厂（工厂不含耦合）；再添加耦合元素；再加入编程】。

如何添加耦合元素？不知道。
分析： 
结构必然是【引入新的游戏目标；实现该目标需要耦合；该目标不由耦合定义】。
这个目标是什么？不知道。
（时间标记T）
分析：
为什么编程需要耦合？不知道。
分析： 
什么情况下才需要耦合？任何时候都需要耦合吗？
并非任何时候。在制作网页时，如果不添加按钮之类的事件，而是单纯的显示一个页面，那么不会耦合。
注：耦合是指【有时候修改一个细节会导致另一些看似无关的东西也需要修改。此时称这些东西耦合在了一起】。

回到时间标记T。
耦合的本质是事件，是大量的【如果……那么……】之间的耦合。（而不是【某处是……】。） 
因此需要让玩家自己创造大量的【如果……那么……】。
异星工厂中有蓝图，但蓝图只是自定义【某处是……】，而没有自定义【如果……】。
如何添加对自定义【如果……】的需求？
我想起来了《群星》。群星中玩家需要建立哨站，我对默认哨站很不满意、但又无能为力。
我想起来了《mindustry》，我在其中自定义了一个哨站蓝图，但是遗憾的是这个蓝图在这款游戏中没有用武之地。
以群星的哨站为需求（本质是群星中的争霸需求），以mindustry中的自定义方案为基础，叠加【如果……】式的耦合。设结果为X。
先类似异星工厂，再进入X，再进入编程，这就是正确的编程教育方式的轮廓。  

一种具体的游戏过程是：
玩家流落异世界，采集食物来生存。
地图上有野兽（以及其他部落与大势力哨站），玩家采集木头石头，制作武器攻击。
玩家建立了一个基地，有箱子存储食物与材料，有城墙防御野兽攻击。
玩家建立大型工厂，优化蓝图，制造火箭前往其他星球，制造装备与士兵。（难度相当于异星工厂的绿瓶）
玩家设计哨站蓝图，设计哨站士兵的行动逻辑。然后用哨站占领其他星球。
玩家与其他势力争霸，最终消灭其他势力获得胜利，在此期间设计复杂的耦合蓝图、并在重玩中优化，并基于此而拥有编程思维。 
（此时可以进入正式的编程课程，也可以不进入、而是让游戏到此为止。）  

总结： 本文的关键在于指出了：【编程】降阶为【蓝图、带“如果”的蓝图、复杂耦合蓝图、编程】。