### 摘要
问题：
游戏开发时，允许撤销一步很简单，但若允许两步、那么很难。但人的直觉觉得撤销两步也简单。为什么？
其实人并不永远觉得简单。如果一个玩家的众多行为无逻辑，那么别人会觉得允许他撤销两步很难。
逻辑在这里的作用是什么？

结论：
人不是回忆，而是编造，现场创造历史，并随机回忆一些记忆碎片、观察那些碎片与自己的编造是否有矛盾，无矛盾则认为自己创造的历史是正确的，有矛盾则修改。
创造历史需要逻辑（也需要无矛盾），这导致如果真实行为有逻辑、那么更容易被【准确的创造出来】，从而表现为【回忆起来】。  
这种【编造式回忆】，本质也是生成判断：生成编造的历史，判断其与自己随机回忆起的一些记忆碎片是否有矛盾。
### 正文
《最后的咒语》是一款回合制游戏，一回合一名玩家可以执行多个操作，并且可以撤销上一步操作。 
注意：
1.不可以撤销两步。 
2.撤销一步之后，再做其他操作（A），可以撤销A。
即： 可以使用无数次撤销，但不可以连续撤销两次。

为什么这样规定？
无解。本问的解需要基于对制作者的了解。
但可以对素材进行加工。
加工：基于不完全信息素材A，规定问题B的解而得到完全信息素材C；基于C，思考D。
此处，A是最后的咒语，B是【为什么这样规定】，CD见下文。  
C： 
为什么不可以撤销两步？
不是因为制作者故意让玩家只准撤销一步、增加难度。
而是因为：撤销两步很麻烦。 
撤销一步的话，可以这样做： 
定义一个全局变量【过去局面】。
每次玩家执行操作：将【过去局面】设置为【操作执行之前的局面】。
每次玩家点击撤回：以【过去局面】、重新显示游戏。并将【过去局面】设置为【无】。
时刻判断：如果【过去局面】不为【无】，那么撤回按钮高亮。否则黯淡。
而撤销两步就不能用这个方法了，需要设计新的方法。
（如果定义两个全局变量，那么你尝试书写后续逻辑时、会发现很复杂。后续逻辑：上一段四行的后三行。）  
D： 
为什么人的直觉觉得【撤销两步很简单】？
这个问题首先需要准确描述。并非所有【人】，而是【不了解编程的人】。 
并非【不了解编程的人】。一个了解通用信息处理、经常准确描述的人也不会觉得撤销两步简单，因此是【缺乏准确描述的经历的人】。
什么叫【准确描述】？就是描述【从起点、经历过程、到结果】，【从简单功能、经历一些逻辑、到允许撤销两步】。 
因此问题改为：为什么缺乏【从起点、经历过程、到结果】的描述经历的人，直觉觉得【撤销两步很简单】？
答案是：因为他们不是思考【如何从起点、经历过程、实现撤销两步】，而是【如何判断一个按钮能否撤销两步】，并发现很好判断，于是认为实现撤销两步很简单。
进一步是这样的：
【假如我是游戏掌控者：假如这不是一款电脑游戏，而是在我脑海中运行的游戏、其他玩家口述他们的操作。那么当他们需要撤销两步的时候，我能很轻松的允许他们撤销。因此我认为：计算机也应当很轻松的允许我撤销两步。】
这暴露出一个问题：如果人掌握游戏，那么人可以允许撤销两步、并且不基于【从起点、经历过程、到结果】的思维方式。
那么人是怎么思考的？ 能否让计算机也这样思考？  
首先可以观察到的一点是：人没有主动记忆【某玩家上一步做了什么】，这导致当被问到【撤销之后的状态是什么】的时候，人无法像被问【某玩家释放某技能之后的结果是什么】那样迅速回答，而是要回忆一下：【他刚才做了什么？】
当需要撤销两步时，这个回忆通常需要更加认真（除非这两步之间有很好的逻辑关系，比如“先移动，再攻击”）。
等等，逻辑关系？逻辑关系在这里起到的作用是什么？为什么有逻辑关系的行为更容易回忆？ 如果是像计算机那样调取硬盘数据的话，那么逻辑关系不应该影响回忆速度才对。
除非：人不是回忆，而是编造，现场创造历史，并随机回忆一些记忆碎片、观察那些碎片与自己的编造是否有矛盾，无矛盾则认为自己创造的历史是正确的，有矛盾则修改。
创造历史需要逻辑（也需要无矛盾），这导致如果真实行为有逻辑、那么更容易被【准确的创造出来】，从而表现为【回忆起来】。  

延伸问题：
人基于哪些底层结构来创造历史？
创造历史，必然基于自身的世界观。比如掌握游戏时回忆【某玩家刚才做了什么】时，必然基于对【此人】【此人的行为】【我】【此游戏】【此游戏的设定】的印象。
然后还要基于一些记忆，记忆的本质是情绪。比如【此人做了那些事、我产生了什么情绪】。
世界观是如何被创造与修改的？ 此处的世界观还包含微观世界观，比如对【此人】的了解就属于微观世界观。微观世界观几乎时刻在改变。
本部分中的问题在本文无解，未来可以慢慢思考或结合新信息思考。（部分：一个引用框为一部分）
#AGI/实验/最后的咒语：逻辑对回忆的影响