### 生成判断算法
对于如下两种情况：
1.一个罪犯偷偷藏在你家里，你不知道他的存在。
2.你让一个罪犯藏在你家里。
当警察敲门问话时，如果你是2，那么你很难装作1。你在与警察对话中会露出大量的破绽，被警察识破、怀疑、调查。
为什么很难装作1？
观察发现：因为你面对问话时的思考方式是生成判断。面对问话，生成一个答案，判断要不要这样说。生成时会基于所有信息、基于家里藏了罪犯，你只能在判断时判断“这样说会不会露馅”，当你判断失误的时候就露馅了。那些受过专业反侦查训练的、不会露馅的人，本质上并没有改变生成器，只是强化了判断器。
这就是人脑的生成判断算法。生成器算法由基因决定，判断器算法可以基于后天学习而改变。
题外话：
问：要训练反侦查能力，只能强化判断器吗？生成器真的没法改变吗？能否干脆不生成错误答案？
答：并非只能强化判断器。可以让生成器不生成错误答案。在介绍具体的方案之前，先说一个信息：生成的结果，由【生成器算法】与【记忆库】共同决定。其中，生成器算法无法改变，但是记忆库可以改变。因此，具体的方案就是：自我洗脑，改变自己的记忆库，让自己相信“家里没有罪犯”。自我洗脑的要点在于：1.不要对原记忆库修改，而是要抛弃原记忆库、重新创造一个新记忆库。2.不要使用否定句来构造新记忆库，要使用肯定句来构造新记忆库。即，新记忆库中不要有【家里没有罪犯】这样的内容。
### 生成判断的速度
生成判断至少每秒上万次。理由如下：
对于如下两种情况：
1.你写过一百个千字文章。
2.你写过一百个万字文章。
如果现在给你一段话，让你回忆它在哪个文章中，那么情况2要比情况1的回忆更简单。因为情况1你可能拿不准它在哪，而情况2你几乎一下子就知道它在哪。（前提是单个文章内部信息相关）
为什么字数多反而效率高？
观察发现：对于第二种，你是先从一段话A想到了与之相关的BC，然后思考的【ABC在哪个文章中】。思考方式是生成判断，是生成一个文章、判断在不在这个文章中。判断【A在这个文章中吗】的准确率比判断【ABC在这个文章中吗】的准确率更低，因此第二种只需要一次有效生成，而第一种需要多次有效生成。（有效生成：每一次判断为“是”时，会有一个“置信度”。如果置信度高，那么就直接输出生成结果；如果置信度低，那么就继续生成，如果长期没有其他置信度更高的生成结果，那么就将此生成结果输出。每次判断为“是”时就是一个有效生成，有效生成不代表输出。有效生成可以被意识观察到。）
总结：虽然第二种情况字数更多、思考过程更曲折、生成的工作量更多，但是由于它判断准确率高，因此它更快。即，思考速度几乎只与判断准确率有关，与生成的工作量无关。要想达到这个表现，至少需要每秒生成上万次，才可以使得【多增加几百次生成、对于整体的速度几乎没影响】。
题外话：
我认为，不存在【置信度】的概念。所谓的置信度，本质是【检验】：当生成为【是】时，会再次生成同样的内容，如果依然为【是】，那么就输出。如果第二次结果为【否】，那么就重新生成其他内容。所谓的【如果长期没有其他置信度更高的生成结果，那么就将旧生成结果输出】，本质是【如果长期没有“双是”的生成结果，那么再次生成到过去的生成结果时、就更大概率出现“双是”】，进一步的本质是【思考时会有一个“结束思考”的欲望、随时间增强。判断的时候，“判断为是则可以结束思考”可以作为一个判断为是的理由。判断器的单次判断是不严格的、是半随机选择单一理由然后去验证的，欲望的强度表现为“判断器更大概率选择到本欲望为验证理由”】。
另外，由于【两次不严格判断都为“是”、应该会出现大量的错误判断，而人的错误判断很少】，因此也许检验不是【双是】，而是【十是】，即【连续十次生成同样的结果且都判断为是】。
### 判断器单元
判断器的工作是判断【执行这个生成结果能否实现目的】，但这不是单元。上一节中说了，判断器会使用【十是】来验证，每一次小判断是不严格的、是选择单一理由去验证的。
但是，【验证单一理由】依然不是单元。理由如下：
观察下面的对话：
（AB是朋友）
A：“你为什么让我爱国？”
B：“因为你出生在中国。”
A：“如果我出生在美国，你会希望我爱美国吗？”
B：（沉默）“没有如果。你出生在中国。”
B并不是故意狡辩。B没觉得自己说的话有问题。
为什么会这样？
观察发现：B在做出最后一次回答之前，是生成一个答案，依次判断【我反对A的真实原因是它吗】【我这样说之后，对方会被我说服吗】（设这两个问题为XY）。都判断为是的时候，才会回答。但是长期无法生成出能通过判断的回答，所以才因想要结束思考而降低了标准、说出了【没有如果。你出生在中国】。
进一步的，事实上并非判断XY这两个问题，而是判断一个大问题【是否有理由表明我不该说它】，在判断这个大问题的过程中判断了数十个小问题、其中两个最重要的小问题是XY：【我反对A的真实原因是它吗】【我这样说之后，对方会被我说服吗】。
结论：判断器的单元是判断【理由P能否否决Q】，基于此而封装出【是否有理由否决Q】，然后通过【无理由否决Q】来得到【对Q的判断为“是”】。其中，判断器在判断【是否有理由否决Q】时，是【生成一个理由、使用判断器单元来判断】。即，人脑中存在两个生成器：一个是行为生成器（生成Q），一个是理由生成器（生成P）。理由生成器与单元判断器共同构成了判断器。