时间：2025.6.18
执悲：最近编程有什么问题吗？
英俊：我感觉难以进步。比如我遇到一个bug，我让AI帮我修复了，但我还是很难受……我不知道怎么说。
执悲：你觉得下次还会出同样的bug？如果是，那么在AI修复完毕之后你去理解问题的根源。如我之前所言：初学者在完成一系列从简单到困难的任务时，简单任务AI可以直接给出答案，但中等任务则不能，此时大多数学员会直接崩溃。而那些在简单任务时、AI给出代码之后、提交作业后、又自己去理解代码的学生，则可以稳步推进进度。
英俊：不是。我有去理解代码，我写了注释，我知道这次bug的原因是序列化的时候没给字段加get、因为序列化只能序列化属性。我想说的难受是，我虽然不会出现这个bug，但会出现其他的，而且其他的我还是需要求助于AI。每次求助AI都要大半个小时，很麻烦。
执悲：知道了。那么教你一个技巧：封装。自然语言里一句话的东西，在代码里就封装为一个函数。可以用AI花半个小时封装出来它，只要封装了，那么后续就不用管它了，如此需要求助AI的此类bug只会稳定的越来越少。比如你现在这里，为了存档读档而需要序列化，那么你该做的是尝试直接做一个万能存档函数，能够序列化字段的。这个函数只需要输入路径与对象。这个函数内容由AI书写，写不好的话可以反复改，写完之后你不需要去理解它，只需要会使用它。
英俊：这个方法只能用于编程吧？
执悲：不，数学也可以，一切可封装的都可以。比如数学中定理是一个封装，那么就是：对于一个直觉上显然的定理，即便其证明过程你看不懂，那么也没关系，不要去看它。
英俊：有这样的定理吗？
执悲：有很多。比如中值定理：一个连续函数，如果函数上存在两个点AB的值一正一负，那么函数上必然存在一个点C的值为零。这个很显然，但证明很难。再比如，集合论中的康托定理，A大于等于B且B大于等于A，则A等于B，这也很显然，但证明也非常难。
英俊：范畴还是窄，我希望有更通用的方法。
执悲：好。也有：单元测试法。你不要把整个项目都给AI去检查，你要只提炼出核心的问题。这样AI一次就能给出答案，不需要半个小时。并且这个方法还有诸多好处：
- 增强自己解决问题的能力。很多时候在写单元测试的时候，你自己就会解决了，不需要提问。
- 适用对象广泛。不只是问AI，还有在学校问教授、在自媒体平台问大佬、在职场问同事、在会议上问大佬，都以问单元测试为最好。没人愿意去看你又臭又长的代码，除非你付费咨询；但如果你只问不到十行的单元测试，那么大家都愿意去回答。
- 适用学科广泛。从理科的数学与编程，到文科的历史与政治，都可以使用。数学里你不要直接说一个证明看不懂，你要去提炼出关键的步骤，哪一步没看懂。很多学生说不明白，说每一步都看不懂，我问【你第一步看不懂吗】，他说第一步能看懂，然后我再问【所以哪一步看不懂】，他又回答【每一步都看不懂】，这时候我就很高血压。再比如我讲一个管理方法，解释其有效的原因，作为学生也不该直接说【没听懂】，而是需要具体说哪里没懂，最好能基于我的理论而构造一个最小矛盾案例来反驳我——这就是单元测试，这样我就能瞬间理解你的误会并且解释（当然也有小概率我确实错了，我也会承认并夸赞你的敏锐）。
#关键词/待定/单元测试法
英俊：知道了。我尝试一下。这是我抽离出来的结果：
``` C#
namespace 仓库练习项目 {  
    class 测试 {  
        public class 仓库类 {              
            public List<string> 道具 = ["1","2","3"];//会故障。需要加入{ get; set; }
        }  
        public static 仓库类 仓库=new();  
        public class 测试1 {  
            private readonly JsonSerializerOptions options = new JsonSerializerOptions {  
                WriteIndented = true,                      // 美化输出  
                ReferenceHandler = ReferenceHandler.IgnoreCycles, // 处理循环引用  
                MaxDepth = 64,                              // 设置最大递归深度  
                Encoder = System.Text.Encodings.Web.JavaScriptEncoder.UnsafeRelaxedJsonEscaping  
            };  
            public void 输出(仓库类 仓库) {  
                string json = JsonSerializer.Serialize(仓库, options);  
                Console.WriteLine(json);  
            }  
        }  
        public static void Main() {  
            测试1 测试1 = new();  
            测试1.输出(仓库);  
        }  
    }  
}
```
执悲：你从五百行的项目抽离到几十行，不错。但还是太复杂，可以压到十行以内：
``` C#
namespace 仓库练习项目 {  
    public class MyClass {  
        public List<string> Items = ["1", "2", "3"];//会故障。需要加入{ get; set; }
    }  
    public class Program {  
        public static void Main() {  
            Console.WriteLine(JsonSerializer.Serialize(new MyClass()));  
        }  
    }  
}
```
英俊：知道了。我会认真阅读与思考。