**理念：如果一个基于四线程+插入系统的婴儿智能体能在一个由伪智能体构建的动作社会中成长得不弱于其他伪智能体，那么这个婴儿智能体可以在不改变算法的情况下（通过改变环境）成长为完备智能体。**
定义：
#AGI/算法核心流程/动作社会
【智能体】
定义：人是智能体，通用人工智能是智能体，哺乳动物是智能体，基于强化学习算法的AI也是智能体。有其生活的环境，且能够在与环境的交互中进步的，就是智能体。

【完备智能体】
定义：只包括人类、通用人工智能、以及更强的存在。至少能掌握语言能力。

【婴儿智能体】
定义：不含（或只含少量）先天知识的智能体。比如人类婴儿。

【伪智能体】
定义：使用先天知识构建的、在行为上类似于智能体的存在，但没有进步能力。比如GPT，单机战略游戏中的AI。
注意：伪智能体不属于智能体。

【动作社会】
定义：不含语言、但拥有复杂的成员关系的社会，时间不可逆流。比如猴子社会，不含语言的EVE社会。
#AGI/算法核心流程/输入、处理、输出系统
【输入系统】
定义：智能体的输入系统，从环境中获取信息的唯一途径。人类的输入系统包括视听嗅味触等，游戏世界中通用人工智能的输入系统可以只有一种：神识。神识获取周围一定范围内世界格子的全部信息。

【输出系统】
定义：智能体的输出系统，对环境做出反馈。人类的输出系统包括肌肉。游戏通用人工智能的输出系统可以只有一种：指令。

【处理系统】
定义：对输入进行处理，决定输出。

【切片处理系统】
定义：只基于当前的输入，来决定输出。当前的时间片被切片了，从时间长河中独立出来。
当代的GPT以及各种AI都是切片处理系统。

【记忆处理系统】
定义：当前的输入+X来决定输出，输出后修改X，下一刻的输入与下一刻的X决定下一刻的输出。这里的X就可以被称为记忆。
GPT4.5引入了简单的记忆系统。

【黑洞处理系统】
定义：基于记忆处理系统。额外有一个线程，对记忆进行不断的整理、重构。这样的记忆系统可以被称为黑洞。取自【黑洞如同你的知识库，跟随你的前进，不断吞噬你的行为、消化。你基于现状与黑洞而做出决策】。
此时有两个线程：输入输出线程，记忆整理线程。因此也被称为两线程系统。

【四线程系统】
定义：基于上面的两线程系统，将输入输出拆开、引入【索引组】的概念。
输入的信息经过预处理后放在索引组，输出系统基于索引组的状态而决定输出。
与此同时，索引组本身也在不断的整理与重构，基于索引组与记忆。即，索引组=F(索引组,记忆)。
如此是四个线程：
- 输入系统时刻将收到的信息预处理后放入索引组
- 索引组时刻整理自我。基于索引组与记忆
- 输出系统时刻基于索引组而输出（注意：输出通常会被输入系统所观察到，从而基于此被纳入索引组。并不是直接纳入索引组。这就是为什么唱歌要带耳返、先天聋子都是哑巴、孩子闭眼无法站立。）
- 记忆系统时刻整理自我。基于索引组与记忆

【插入系统】
定义：插入系统类似于预处理，但有所不同。预处理不调用记忆，而插入系统会调用。
以触发或轮询的方式，当索引组的状态满足某条件时，会给索引组中插入一个原子信息（比如Enum），从而诱导索引组在整理时不断满足更强的条件、并因此而被插入更多的信息，并最终导致输出系统做出特殊的输出。
这个插入的原子信息，可以被称为情绪。
推论：情绪的激发需要多轮整理，在多轮中的任何位置都可以打破。在某一轮时，如果注意力转移，索引组被重置，那么情绪就会消失。
推论：【多轮】的数量是巨大的，每一轮是快速的，每秒万轮以上。注意力转移，本质是在索引组中引入了新的信息，并诱导索引组在整理时不断扩张这个信息的相关信息、清理其他信息，从而表现为重置索引组。注意力转移本质是一个【多轮】，而这个多轮表现得极快、一瞬间完成转移、如同情绪激发中的【多轮】中的一轮一样。因此情绪激发中的【多轮】是一个巨大数量的多轮，但它时间也不长（愤怒只需要一秒左右就会点燃），因此速度是快速的。
注：插入系统很可能是触发而不是轮询，因此它虽然似乎是【时刻生效】，但不作为一个线程。