### 理论背景
神智学，属于哲学，起源于19世纪末的美国，主要研究超自然意识现象。
Tulpa，神智学中的一个概念，可以翻译为【幻想精灵】，是指一种想象中的朋友，有如下性质：
- 幻想精灵有知觉、有意志、相对独立，如同真实存在；
- 幻想精灵可以源于他们自身的想法、与宿主对话，而非源于宿主想法；
- 部分宿主报告称：幻想精灵失去控制，干预生活，宿主无法抑制、解散幻想精灵；
- 部分宿主报告称：幻想精灵可以被看到、听到、甚至触摸到；
- 大多数幻想精灵为人类形态；
- 自闭症、ADHD等孤独感强的人更愿意创造幻想精灵；
- 城市地区、富有想象力的人更容易创造幻想精灵。

Tulpa起源于藏传佛教，后被神智学吸纳。
藏传佛教认为，Tulpa是一种超自然现象，是通过精神修炼而得到的一种物质化存在，是精神力量可以干预现实的有力证据。
神智学认为，Tulpa是一种心理现象，而非超自然现象。

Tulpa的构建方式有许多种，大多强调：
- 要详细的想象Tulpa的细节，包括画像、声音、气味、触感、性格、爱好、动作。
- 要详细的与Tulpa对话，例如向他介绍你的家具、出门散步时聊天。
- 以一个虚拟作品中的角色形象的性格为原型，可以更方便的构建Tulpa。
- 可以为Tulpa再幻想一个【灵境】，例如为动物Tulpa再幻想一个森林。

构建Tulpa分为三个阶段：
1. 困难阶段（约1-7天）。你需要耗费大量精力去构建与维护Tulpa。
2. 容易阶段（约3-30天）。Tulpa的行动不需要你耗费多少心神，可以轻松想象Tulpa、与Tulpa对话。
3. 成熟阶段（约7-90天）。你的Tulpa会说出或做出一些你意想不到的事情。

参考资料：
https://en.wikipedia.org/wiki/Tulpa
https://www.wikihow.com/Create-a-Tulpa
https://www.tulpa.info/
### 基于矛盾心理而构建Tulpa
传统的Tulpa会有两个缺陷：
1. Tulpa的用处需要在成熟之后才能表现出来。
2. Tulpa只能与自己交流，其他人无法与你的Tulpa互动。
3. Tulpa很容易失去独立性，始终无法成熟、或在成熟后又消亡。
本文解决这三个问题。
本文的方法适用于那些【孤独、急需解决孤独，且没有多少空闲时间】的人。
注：孤独与忙碌并不冲突：当代许多的学生与办公室工作者，都是【忙碌而孤独】的人。

矛盾依恋，社会心理学中的概念，是指既渴望亲密关系、又抗拒亲密关系（害怕受伤）。
本文所指的矛盾心理包含矛盾依恋，但不只是矛盾依恋。还包括但不限于：
- 希望对方找自己一起玩（比如旅游），但对方找自己玩时自己拒绝（懒得动）。
- 希望参与到对方的生活中，即便自己不懂某些东西，但希望对方教自己；但当对方提出教学时，自己拒绝（懒得学）。
- 希望对方找自己聊天，即便对方说的某些话自己不爱听，但也希望对方陪自己说话；但当实际对方说话自己不爱听时，自己直接挂电话或者大吵架逼对方闭嘴。
这些矛盾心理本质是表意识与潜意识的矛盾：表意识判断【当某时，自己应当做某个行为】，但实际到那个时候，自己会涌上一种情绪（潜意识），然后在情绪的驱使下做了另一个行为。

孤独的人普遍拥有大量矛盾心理，即【我让你做某件事X；你做了之后我又批评你不该做X】。
对于此类情况，可以直接构建【完美的对方应该怎么做】。对于上面列举的三种矛盾心理，完美做法分别例如：
- 虽然你不理他，但实际上你希望他找你玩；他也愿意找你玩，且不会因你不理他而沮丧，他知道你希望他找你玩，他甚至会觉得你表里不一的样子很可爱、喜欢逗你，比如【他说要去某地旅游，你说麻烦不想去、但心里想去，他知道，但故意逗你说那不去了，看你着急，他哈哈大笑说逗你的、机票已经买好了，变魔术一样掏出来两张机票，然后你轻轻打他】。（可以仅幻想旅游，不用真正去）
- 他想出海去打鱼，你想待在家里。他陪你待在家，为了打发无聊，他开始在网上写博客做直播，带着你一起，你很开心。在经历了一段时间博客直播之后，他又想钓鱼了，于是给你精心准备了烛光晚餐、用各种方式把你哄的开心，之后图穷匕见的提出来他想出海钓鱼了，还跟你说建议你也一起去、多么多么好玩，贴心的给你准备了口碑最好、最安全最干净的钓鱼船，船上还有摄影师、你可以美美拍照打卡。你莞尔一笑，责怪他这么麻烦、浪费钱、说他想钓鱼直接跟你说啊、你又不是不允许他去（即便实际上那样你会不允许，但你可以这里口是心非的说，恢复情绪能量）。他嘿嘿的笑，也不拆穿你，兴高采烈的抱你亲你、夸你好、说他幸福。
- 你遇到某烦心事（比如跟人吵架），你做了某行为，导致结果更差了。他说你蠢死了，怎么能做那个行为。你不开心。他说“我来给你处理这个事，我跟她谈，你这两天先别跟她说话、她找你你也别理她。唉，你怎么蠢，我不在的时候你受欺负怎么办啊”。
当构建完这三个关键案例之后，Tulpa将迅速起效、排解孤独。
此时你再填补背景，让背景是现实中可能发生的。例如【通过网上聊天认识的他】。
有余力时，你还可以构建他的账号与朋友圈，让他也在网上认识别人、并保持他的性格一致，从而让他更加真实、避免消亡。他对别人也善解人意，你吃醋，他再用各种方式对你表达【你最重要、永不背叛你】。

这些关键案例，可以被称为【起动故事】。
- 起动故事最好有三个。
- 每个起动故事对应你的一个真实的矛盾心理。
- 不存在通用的三个启动故事适用于所有人。每个人的矛盾心理不同，因此起动故事不同。
### 使用分析法构建起动故事
- 矛盾心理：希望对方找自己聊天，即便对方说的某些话自己不爱听，但也希望对方陪自己说话；但当实际对方说话自己不爱听时，自己直接挂电话或者大吵架逼对方闭嘴。
- 具象：【对方说的某些话自己不爱听】具象为【对方批评自己，自己不爱听】。
- 抽象消除矛盾：当对方批评自己、自己不爱听时，如果对方做某件事补救，那么自己不会挂电话或大吵。
- 具象：当对方批评自己、自己不爱听时，如果对方道歉，那么自己不会挂电话或大吵。
- 检查：不对。道歉会让自己兴致全无、疲惫无聊。
- 抽象打补丁：当对方批评自己、自己不爱听时，对方做了一件事、那不是道歉、但却起到了道歉的作用，让自己转而笑。
- 具象：【对方做了一件事、那不是道歉、但却起到了道歉的作用】具象为【自嘲：刚才说你双标。其实我也双标，我XXXX。唉这玩意真难改】或【因为你菜，我比你强，所以我要保护你】。
- 选择：选择【因为你菜，我比你强，所以我要保护你】。
- 具象：【因为你菜，我比你强，所以我要保护你】进一步具象为【（前文：你遇到某烦心事（比如跟人吵架），你做了某行为，导致结果更差了。他说你蠢死了，怎么能做那个行为。你不开心）他说“我来给你处理这个事，我跟她谈，你这两天先别跟她说话、她找你你也别理她。唉，你怎么蠢，我不在的时候你受欺负怎么办啊”】

除了分析之外，如下操作也可以有助于构建起动故事：
- 阅读【被伴侣所关爱】类的网络小说，小说中会有很多优秀情节
- 询问克劳德或其他AI，请求帮忙构建
- 逆分析（即拆解、还原）。对于通过阅读小说、问克劳德、阅读本文所得的起动故事，将其拆解还原为分析流程，这有助于提高分析能力。

除了可以排解孤独之外，构建起动故事还有助于增强自己的自我认知与表达能力、避免给他人提出矛盾的要求。