### 一阶多线程能力：经验
错误：做菜要焯水。先切菜，再烧水，然后站在那里等水烧开，再下菜。
正确：做菜要焯水。先点火烧水，再切菜，切完菜水也烧开了，下菜。

问：这有什么用呢？
答：节约时间，几乎节约一半的时间。
当你从零阶进入一阶后，你的平均时间利用率将翻倍。
很多人忙碌一天，实际产出少得可怜，于是只能压榨睡眠时间、多挤出来两三个小时。
但如果进入一阶，那么你每天自动多出来六个小时时间，不需要压榨睡眠时间。

问：生活中没什么多线程的事情。
答：怎么没有？
第一，吃饭的时候，洗漱上厕所的时候，都可以做一些能多线程的工作，比如思考一个复杂问题。而不该在正式工作时间时把它们做了、导致吃饭洗漱时无所事事。
第二，跟人交流的时候，尤其是线上交流时，一大半的时间都是空闲的，但是很零碎。这个时间里你也可以做一些能做的事情，比如查资料、拆快递、晾衣服，而不该在正式时间拆快递。

问：如果水烧开了，菜还没切完，怎么办？一着急，切到手了，得不偿失。
答：这就是为什么我说是【多线程能力】而不是【多线程意识】。
意识，是指【你意识到，立刻就能改】。
能力，是指【你意识到，也未必能改，你需要一些配套的东西】。
多线程能力，就是【多线程意识+不要出现线程失调等情况、或者出现也有淡定的解决办法】。

问：怎么淡定解决？
答：比如烧水，第一，切菜的时候时刻关注水的进度，尽量保持双方进度一致。类似于，吃盒饭的时候时刻关注菜与饭的比例，保持双方进度一致，从而最终一起吃完。
第二，如果有大量的菜需要切，那么就切到一半再烧水，或者烧水的时候使用小火。
第三，如果以上都忘了做了，那么当水开之后使用小火、保持最低沸腾，并偶尔添水，然后淡定切菜。
不同情境，淡定解决的办法不同，这些办法可以通过经验或分析得到。没法穷举。这就是一阶多线程能力的关键所在。
### 二阶多线程能力：规划
一阶的人，需要在很熟悉做菜时，或者听别人讲过做菜的多线程步骤时，才能多线程工作。如果他第一次做菜，也没听说没看到过别人多线程做，那么他自己不会多线程做。
二阶的人，第一次面对做菜的需求时，就在脑袋里明确了所有要做的操作、规划好了先后顺序，然后执行。规划中天然就是多线程的。这种人在厨师学校里会被称赞为【你是不是以前学过厨师？】【没学过？奇才啊！你就是干厨师的料！好好学，我可以把衣钵传给你，我等着你飞黄腾达后我跟着沾光】。
相对应的，一阶的人得到的评价会是【踏实肯干，知错就改，可雕之木，很好】【我要退休了。你过来，今天教你这个东西，这是我压箱底的手艺，好好学】。（即，一阶只在临终时传承、因为认为弟子的上限是师父。而二阶是立刻传承、因为相信弟子的上限不可估量。）
零阶的人得到的评价会是【哦？那个谁？有印象】。

问：凭什么说二阶强？一阶靠经验怎么了？结果不一样吗？
答：不一样，很多东西是没有经验的。
比如我前文问答中提到的【吃饭洗漱时想问题】【线上交流时拆快递】，这些都是没有经验的。

问：你现在说了吃饭洗漱、线上交流的问题，我可以立刻改，这不够吗？没有什么其他多线程需求了吧？我认为多线程需求并不多，穷举后用经验处理即可，一阶够用、二阶没必要。
答：多线程需求非常多。所有人通用的需求少，但任何工作都会有专用的多线程需求，无法穷举。
比如现代社会的一大类需求：延时工作必须尽早开始。
- 烧水是一个延时工作：点火不能立刻得到开水，你付出再多精力也没法让水烧开得快一秒钟。
- 注册公司、申请专利、以及各种与政府部门打交道的事情是延时工作：你需要提前一周、甚至一个月、甚至一年来处理，因为政府流程非常慢、你急也没用。不能等需要的时候再做。
- 网购、招聘、布置任务等事情是延时工作，不能等你忙完了再布置任务，要先给下属布置完任务之后再去忙你自己的事情。
编程是一个好工作。为什么？因为所见即所得，编程中几乎没有延时工作：你不需要频繁与别人交流，也不需要面临物理实验那样等待器材运送、等待实验运行。编程中，你是造物主、把控一切，你付出一份精力，那么任务时间就缩短一份。
除了编程之外，其他一切工作中都会有大量的延时工作，每一种延时工作都对应一种多线程需求。

问：如何拥有二阶多线程能力？
答：看题目：规划。
对于插入少的情况：先明确你一共有哪些事情要做，列一个清单出来。然后分类整理，安排任务计划，然后执行。
对于插入多的情况：先明确你一共有哪些事情要做，列一个清单出来。然后分类整理，明确现在做什么，执行。做完之后，或者面对插入时，更新清单，然后重新决策现在做什么。
插入：即打断，比如下属报告了一个紧急情况；或者上级布置了新的任务。
### 三阶多线程能力：极尽优化
许多看似不可能多线程的工作，在三阶中将得以多线程化。
一阶二阶都只是单纯的对工作进行重新排列，而三阶会改变工作本身，使其在少量提高工作成本的情况下、巨大的契合多线程工作，从而总工作成本降低。（把一个工作从不可多线程变为可多线程，相当于让它成本除以二。因此，对于一个100成本的工作，增加20点成本使其可多线程化，相当于总成本为(100+20)/2=60，总成本降低了。）
例如，基于外置记忆的思想，可以有如下极尽优化：（外置记忆：见于[[逻辑记忆能力]]）
- 48寸显示器可以同时阅读大量代码，但难以阅读，对此使用外置记忆法+压行规范，编程中压行规范方便外置记忆。见于：[[01丨轲目苦津代码规范：压行]]
- 48寸显示器可以同时回复多账号消息，但容易记忆错乱，对此使用外置记忆法+一回合交流规范（发言需要清晰完整，不要一条一条的发，不要说【在吗】【收到】之类的废话）。一回合交流规范会方便外置记忆。
再例如，预测印证法：（见于[[三明治效应与多线程工作法则]]）
- 当线下进行多回合交流时，预测对方接下来可能做什么，然后拟好回复（有时分类预测），同时思维可以转移到其他线程，当对方给我反馈后我将他的反馈与我的预测对比、对比通过就直接机械执行之前拟好的回复。
- 多线程工作的上限远高于单线程，但却有注意力不够用的缺点；预测印证法可以大幅度降低注意力需求，但会带来理解能力不够的缺点；强色彩词汇（即不要委婉）可以大幅度降低理解能力需求，但会带来信息失真的缺点（直话伤人）；L等级可以低成本保证信息真实。基于此，预测印证法需要与【强色彩词汇】【L等级】结合，被圈子中所有人共同遵守。
- 注：机械执行：很多动作是可以机械执行的，例如吃饭、穿衣服出门、上车下车、买东西。甚至包括打字。脑海中射线模式规划好后续要做什么（射线：越近越详细），后续由躯体机械的按规划执行，脑海中思考更远的事情或其他线程的事情。脑子比手快。
- 注：射线模式：射线模式的应用很广泛。工作规划，小说大纲，都应当使用射线模式：越近的越详细，越远的越简略。

不过，俗话说：快人一步是先驱，快人两步是先烈。
二阶快人一步，被世人称赞；三阶快人两步，会被世人诋毁。
三阶是【(100+20)/2】，由于人们通常做不到二阶，因此人们在三阶时无法【除以二】，因此人们面对三阶时只能【100+20】，因此会骂三阶的发起者【低效率、多此一举】。