### 【前言】定位
- 如何用AI写小说？
	- 当代AI写作的缺陷
		- DeepSeek写作的缺陷
			- DS缺陷：收
			- DS缺陷：飘
			- DS缺陷：碎
			- DS缺陷：浅
			- DS缺陷：崩
			- 解决方式：从宏观到微观
### 【前言】定义、
收：DS太有道德，仿佛一直收着力道、放不开，不会设计冲突。
``` C#
好的冲突是螺旋上升的，双方互相升级。比如：你骂我一句，我推你一个趔趄，你扇我耳光，我踹你飞出去，你抄起棍子。
而DS的道德感会导致它会默认不升级冲突。
这个也是所有大模型都有的问题。
因为大模型要想发布到社会上，那么一定需要经历道德约束，不然各国不会允许发布。
```
飘：DS的设计太过天马行空。
``` C#
例如：主角开一个奢华派对，让DS去写。它能写成【霓虹秘境：人工智能生成艺术工作坊】或者【云端茶叙：高空茶室与日式枯山水庭院结合空间】。
但我想要的只是一个普通的奢华派对。
```
碎：DS的设计太多，太不成关联。
``` C#
1.DS不会使用伏笔。如果它写一个东西，那么一定是当下立刻有用的；否则它不会写。不会为未来做准备。
2.DS经常抛出来一个读者以为重要的东西，然后就没后文了。
这导致它写短篇还行，长篇就崩。
```
浅：DS不会写出【有深意的话】。DS的发言可能有深度，但不会有深意。
``` C#
深度：振聋发聩。
深意：初识不知曲中意，再识已是曲中人。
这个问题是大模型算法决定的，所有大模型都会有此问题。
因为大模型底层算法是【把所有历史作为输入，然后预测下一个字的输出。如此循环往复，直至输出结束符（一个不可见的符号）】。
所以，大模型说出来的东西，必然是【它自己无论看多少遍都能看懂的】。
而深意的发言，它自己看很多遍、可能会有不同的理解，会导致它【反复的一个一个字预测】会输出紊乱。
所以，一个大模型要想能说人话（连贯的、不紊乱的），那么它必然不能输出深意的发言。
```
崩：DS会编造不存在的设定，写出来的情节前后文矛盾
``` C#
这个是所有大模型的、所有行业的问题。不仅是小说。
你问DS一些科学常识，它有时候也会一本正经地给你编造错误的答案。
这在学术界被称为【幻觉】。
随着大模型的发展，在科普领域，大模型的幻觉率越来越低。（幻觉率也是大模型排名的重要指标）
但在小说领域，前后文矛盾的幻觉依然大量存在，尤其是当字数越来越多时。
```
### 【前言】解决方案
解决方案很简单：你写细纲，让AI写正文。
这个细纲需要非常详细，一章2000字正文，你细纲至少600字。
比如说，在这个背景下：
``` C#
主角是金丹修士，穿越到地球。各国政要富豪恭敬对待，送来金钱、权力、土地等。
主角建国，并且包含赌场、甚至允许赌命。有人支持，有人谴责。
龙国没有谴责，但禁止国内民众讨论关于赌命的话题。
主角约谈龙国代表，要求解除言论限制。
```
如果你让AI来写主角跟龙国的谈话，那么很没意思。
最大的问题就是我上面说的【收】：AI不会写冲突。主角跟龙国吵不起来。
怎么冲突起来？
第一，龙国需要刚，不能解除限制。
第二，主角需要刚，必须解除限制。
第三，龙国不能蠢，不能故意得罪主角。
第四，看第一条。龙国需要刚。需要既刚又不蠢。
所以提示词需要怎么写？
``` C#
我需要你帮我推演龙国代表的发言。
他的态度是强硬的，又臭又硬。
他无惧于激怒陈峰，但不会刻意激怒。
他会给出一个言论控制方案，这个方案是折中的，听上去很好，但没有明确承诺。实质上权力都在龙国。
```
这样，AI给出的回答中，龙国代表的发言就是：（注：坎顿是主角的国家）
``` C#
“第一，龙国将开发一款新的数字平台，允许经过审核的学术机构、媒体代表、公众人物，参与对坎顿事件的报道与讨论。允许所有人阅读。”
“第二，实施分阶段开放评估机制。龙国将根据社会稳定性、国民接受度等指标，每季度进行风险评估。若条件成熟，可逐步扩大讨论范围。”
“第三，龙国愿与坎顿岛定期交流，并报道在数字平台中。坎顿方面如果有想对龙国人民发表的言论，那么可以在这场交流活动中发言。”
“如果您接受此方案，那么龙国将视您为友好伙伴。”
“如果您坚持强行施压，那么龙国也已做好一切准备，承担任何后果——包括您所提及的后果。”
```
这就很好。
后面升级冲突：主角要求审核规则需要白纸黑字写成法律、此事主角与龙国共同立法，但主角对此拥有最高司法权（并下派司法代表）。
龙国拒绝。主角也摆出臭脾气，甚至表示【我的要求还不止如此。我这条要求只是基础，你答应的话，我都未必答应；但你不答应的话，我绝不答应】。
龙国愤怒，表示那没得谈了。主角表示不谈的话那就准备好迎接毁灭。
龙国愤怒，表示有本事你就来，给你脸了？主角表示走着瞧，结束会谈。
这就是一个标准的螺旋升级细纲。
这样的情节才是有趣的。
AI写不出来。
这个细纲必须要你写，AI只能帮你把这个细纲扩展成正文。
（注：以上情节来自番茄小说《我，金丹修士，降临地球》第48章。这是学员作品，其中第48章是在我指导下写的。）
注意看，细纲里有一句话很关键：
``` C#
他会给出一个言论控制方案，这个方案是折中的，听上去很好，但没有明确承诺。实质上权力都在龙国。
```
这句话是怎么想到的？
这就是本文要讲的关键：从宏观到微观的思维。
### 【正文】从宏观到微观
思考问题时有两种思考方法。
以【设计一款新的厨具】为例：
- 生成-判断：生成一个厨具想法，判断是否合理，不合理的话重新生成一个。如此否决几十个想法，直至发现一个判断为合理的想法。
- 宏观-微观：这个厨具需要为了解决一个烹饪问题而设计，目前的烹饪问题分为好几类：不好吃、不方便、不安全……选择一个，方便，我需要设计一个让厨师更方便的厨具。然后……
注意看，从宏观到微观的思维，中间会得到【我需要设计一个让厨师更方便的厨具】这种东西。
这个东西，就是我们写小说时要给AI的提示词。
不要直接让AI去设计厨具，要让AI设计一个【让厨师更方便】的厨具。
不要直接让AI去写龙国的言论方案，要让AI写一个【折中的，听上去很好，但没有明确承诺，实质上权力都在龙国】的方案。
这就是【具体化你的需求】，这就是【细纲】。
### 【正文】从微观到宏观
怎么去锻炼自己从宏观到微观思考的能力？
答案就是：从微观到宏观。
当你看到一个亮眼的东西时，你不要只去看它本身，要去尝试寻找它的宏观对象。
比如我经常说的一个例子：出师表。
``` C#
亲贤臣，远小人，此先汉所以兴隆也；亲小人，远贤臣，此后汉所以倾颓也。
先帝在时，每与臣论此事，未尝不叹息痛恨于桓、灵也。
侍中、尚书、长史、参军，此悉贞良死节之臣，愿陛下亲之信之，则汉室之隆，可计日而待也。
```
它的宏观是什么？
``` C#
你要亲贤臣，因为先汉后汉的客观教训，以及你爹的主观观点。
ABCD是贤臣，你要重用他们。
```
那么这时候你就提炼了一个宏观的：
``` C#
劝人的时候，你需要先提供客观理由、主观理由。
```
那么应用它，你在写AI提示词、塑造一个精通劝谏的大臣时，你就可以这样写提示词：
``` C#
错误：主角要做XX，你来写大臣的劝谏。
正确：主角要做XX，你来写大臣的劝谏。注意，大臣会先给出一个客观事实作为支撑，再引用一个主角尊重的人的观点，最后再说劝谏本身。
```
### 【扩展】写作之外
（扩展章节选读）
这种从宏观到微观、从微观到宏观的思维方式，不仅用于小说，更用于一切领域。
能熟练应用它的话，你不仅能成为一个小说大佬，还能成为一个任何行业的大佬。
本质是这样的：
``` C#
一个难题，会有一个难度分数。可能1分，10分，100分，1000分……
一个人，会有一个实力分数。大多数人算它3分，精英10分，世界之巅30分。
当一个难题小于你的实力时，你将可以使用【生成-判断】直接解决。
当一个难题略大于你的实力时，比如10分的难题、你实力8分，那么你【生成-判断】思考一会儿之后能解决。
因为每次生成，并不是8分，而是以8分为中心、正态分布的概率震荡。
当一个难题极大于你的实力时，你凭借生成判断将无法解决。因为正态分布，越大的数、概率将加速越低。
但是，当你使用【宏观-微观】时，你本质是直接对难题的分数做了一个除法。
1000分的题目变为100分，100分的题目变为10分。
所以：难度使用【宏观-微观】，简单题目使用【生成-判断】。
【宏观-微观】是底层的思维方式，可以削减一切难题。因此适用于一切领域。
```
### 【扩展】陷阱：并非万能
【宏观-微观】不是万能的，它必须与你本身的实力结合。
如果你实力0.1分，那么【宏观-微观】再强也没用。

问：为什么没用？多次【宏观-微观】，多次除法，不就能解决问题了？
答：是可以多次除法。但你会【忽视问题的存在】。
生活中每天你都会遇到数百上千的问题，但它们大多数根本不会被人察觉，一秒直接就【生成-判断】解决了。
如果你实力0.1分，在这大量的小问题上你会都做不好，你不可能一个一个全都去【宏观-微观】。
每一次【宏观-微观】，都很耗费脑力。
平均下来，一天能进行一次【宏观-微观】的思考，坚持一年，那就是很牛逼的人了。

【生成-判断】保下限，【宏观-微观】保上限。
一个精通【生成-判断】的人，他或许解决不了难题，但正常的问题他都能处理的很好。就像是各科都及格的学生。
一个精通【宏观-微观】的人，他或许能解决一些难题，但正常的问题他都处理不好（除非用面对难题时的全神贯注状态来处理）。就像是一科满分、其他科零分的学生。
并且，两种思维模式很难兼容与并存。
一个熟练生成判断的人，庞大的惯性会导致他抗拒宏观微观，总想着【我再想想，很快就能解决了，没必要那么麻烦地动用宏观微观】，并且往往他还真能想到一个不错的答案（虽然不完美，但能凑合用）。并且，久而久之，他会渐渐忘记如何宏观微观的思考，真需要的时候也无法宏观微观了。
一个熟练宏观微观的人，会有一种强烈的优越感，贬低生成判断，让他生成判断就仿佛让他吃屎一样难受。可能他原本实力是3分，但随着他越来越熟悉宏观微观、他的实力反而也不断下滑，变为0.1分乃至更低。

这个问题怎么解决？
没法解决。
尽量自我调节，自我均衡。
生成判断时，不要恐惧宏观微观的成本。
宏观微观时，不要贬低生成判断的愚蠢。
### 题外话
需要职务：宏观微观题目提供者。
很多人不是不想宏观微观思考，而是不知道思考什么，缺题目。
他们有时候能遇到题目，但那时候不想思考。等想思考的时候，又想不起来题目。
所以需要收集题目，每天做一道题，活动一下脑子。
比如本文出现的这个题目：
``` C#
使用从微观到宏观的方式，拆解【亲贤臣，远小人……可计日而待也】的宏观，并基于此而宏观微观地优化AI提示词【主角要做XX，你来写大臣的劝谏】。
```
至少需要365道题（支持一年）。
完成365道题之后也可以出一本书。大概结构：
- 思维方式（共10页）
- 题目（共200-400页）
	- 初级题目
		- 题目篇（页数少）
			- 第一题
			- 第二题
			- ……
		- 答案篇（页数多）
			- 第一题答案
			- 第二题答案
			- ……
	- 中级题目（同上）
	- 高级题目
这本书可能成为所有精英必买的教子女的书籍（并且精英本人也会阅读）。
书籍最好不写小说，只写生活，这样受众广泛、买的人多。
生活题目例如：
``` C#
使用宏观微观的思维方式，对如下问题进行优化：【你因为不懂一个“朋友们都懂的常识”而犯了小错，朋友嘲笑你的愚蠢。这时候，你如果生气、那么会失去这些朋友；你如果赔笑，那么你无法面对自己的内心。此时你该怎么做？】
```
愿意承接此职务的可以联系执悲今厄：QQ 1181807822。也可以在本文下留言。
此项目还可以扩展，出第二本书、第三本书……每本书是一个不同的领域。
第一本书聚焦生活领域，第二本书可以聚焦高考，第三本书可以聚焦编程，第四本书聚焦小说……
职务有三种薪酬模式，你可以选择：
- 固定工资+少量提成。需要考核题目设计能力达到80分以上，达标后给工资、需要按时提交足量题目。（分数主要是描述能力，而非难度。上面演示的两个例子都是80分描述质量的题目。60分表示勉强能写到书上、但最好改改再发布。）
- 纯提成。不限制题目设计能力，你可以提交，我未必采用。对于采用的，发书后按比例算提成。
- 学徒+按采用量算少量提成+转正后固定工资。需要考核题目设计能力达到60分以上，我教你改题目的描述（60优化为80），每次教学你需要付费。我优化后采用的也计你的采用提成。