### 简介
集团，是指一个公司拥有许多不同的业务板块。
例如，马云的阿里集团，主营业务是淘宝与支付宝，但他同时还做钉钉、饿了么、高德地图、阿里云、优酷视频、甚至菜鸟驿站（想不到吧，这些都属于阿里），以及许多国际品牌，比如东南亚的Lazada、欧洲的Trendyol。
轲目苦津也类似于集团，拥有诸多项目（业务）。那么可以参考一下传统集团的运行方式。
集团会有这些部门：
- 股东会：分红权
- 董事会：决策权
- 监事会：监督权
- CEO：执行权
	- 财务部：报销、记账、避税、计算利润
	- 审计部：检查财务部假账
	- 法务部：拟定合同，处理法律纠纷
	- 人力部：招聘、培训、离职、员工档案、员工心理咨询、宣传企业文化
	- 行政部：采购、团建、物业、食堂、宿舍、安保、文员
	- 公关部：媒体品牌形象与影响力（西贝没有独立公关部、而是行政部兼任公关，所以闹出罗永浩事件、舆论自杀。大集团都有单独的、专业的公关部）
	- IT部：内部软件
	- 投资部：投资或收购其他公司（投资与自身互补的公司、收购潜在的竞争对手）
	- 总裁
		- 云团事业部（领导被称为集团副总裁，或者云团总裁）
		- 风神界事业部
		- ……
同时，还会存在这些子公司：
- 云团子公司（集团全资控股。董事会由云团事业部人员兼任。不设CEO。领导被称为总经理）
- 风神界子公司
- ……
### 注意：利润算法
子公司的利润名义上属于子公司，实质上属于集团。集团会通过如下方式来获取：
- 管理费。这是最优先的手段，集团会设置一个极其高额的管理费，几乎可以吃掉所有利润。这作为子公司成本，会导致子公司利润为负数。然后集团再看情况注资到子公司、来弥补子公司的亏损。这样一方面可以避税，另一方面保证集团对子公司的经济控制权。
- 分红。如果子公司利润高到足以覆盖管理费，那么集团会要求子公司分红。集团会提出分红方案、私下安排给事业部（即子公司董事会），然后董事会再提出此分红、集团作为大股东批准。（左手倒右手，董事会与股东会都是集团的人。这个繁琐流程是为了保障法律程序合法。法律上，董事会提案，股东会批准，需要尊重子公司作为一个独立公司的法律流程）。
并且，IFRS（国际财务报告准则）与CAS（中国企业会计准则）都规定，集团在发布财务年报时，必须合并子公司财务报表，而不可以只记录【子公司管理费与分红】。
### 注意：合并办公
对于一个只做线上虚拟业务的集团，各个事业部、子公司，通常都在同一个大厦合并办公。
集团在非业务领域（人力、财务、行政等）提供支持，子公司只需要专注于业务。
现如今，集团越来越多（百度阿里腾讯华为……大企业几乎都是集团），集团合并办公也越来越常见，许多非虚拟业务的集团都强行合并办公，以至于有许多专业的名词：
- BP：业务合作伙伴。例如HRBP（人力资源业务合作伙伴）是子公司对集团HR的称呼。
- SSC：共享中心。例如财务共享中心是子公司对集团报销处的称呼，所有子公司的所有单据都在这里报销。
同时，合并办公还为高额管理费提供更好的理由，更合法地吃掉子公司的利润。
### 注意：子公司激励
子公司总经理肯定不能只发死工资，需要激励措施来保障高效：
- 固定工资：这个是底薪基础。管理一个年营收过亿的公司，总经理的基础工资通常是几万（每月）。
- 年度奖金：这个很重要，几乎可以让收入翻倍。这个是根据本年度的KPI表现来定的，相当于绩效，但是是可量化的绩效，例如营收、毛利率、市场份额、客户满意度等等。所以总经理一般很少说自己月薪，都说自己年薪，因为一个月薪五万的总经理、年薪可能是百万（而不是5×12=60万）。一般来说，一个合格的总经理都能拿满年度奖金（或者拿个八成），如果总经理经常拿不到年度奖金，那么他会被集团撤职、换人，或者直接解散子公司。
- 任期激励：总经理任期一般是3到5年一届，可连任。任期结束时，会再进行一次奖金发放，但不再基于那么多乱七八糟的KPI，而是只基于一个：利润。在任期开始之前，集团会设置一个任期利润目标；任期结束时，如果利润超过目标，那么超过部分的一定比例（任期前约定）会作为奖金发给总经理。
- 期权激励：当总经理做出主动的、意外的、突出的贡献时（例如在董事会规划之外，额外开拓了一个全新市场），授予期权（子公司期权或集团期权）。期权例如【五年内，你可以基于现在的估值（而不是五年后的估值），购买1%的股份】。假设现在公司估值一亿（第三方评估），四年后估值十亿，那么四年后你可以花一百万元购买1%股票（也可以不买）、价值一千万。不过这一千万不是现金，变现有四种方式：
    - 分红：股份最常见的变现方式，1%股份意味着1%分红。
    - 回购：当公司发生融资时，你可以优先出让。即，估值10亿，公司发布新一轮融资：1亿10%。投资人投资1亿，你可以要求【公司出让这10%中，有你的1%】，并立刻拿到一千万现金（失去股份）。
    - 并购：当公司被收购时。例如，四年后估值10亿，你买了100万；六年后经营不善，公司被被其他人5亿收购，那么你立刻拿到500万。
    - 上市：这是最好的情况。当公司完成上市后，可以在股票市场交易，会迎来新一轮估值暴涨，并且你可以随时以估值出售你的所有股份。四年后上市，估值50亿，你买了100万，此时可以直接出售，立刻拿到5000万。即：在股价50元的时候，你以1块钱一股的价格购买一百万股，然后以50元的市价立刻卖掉。
### 注意：独立上市
子公司可以独立融资，独立上市。也可以独立破产（而不影响其他子公司）。
既然集团可以吃掉子公司利润，那么为什么外部投资人还要投资子公司？两大原因：
- 上市。很多投资人并不在乎利润分红，指望分红回本、要等到猴年马月？投资人关注的是上市，上市之后转卖股份来赚钱。而上市锚定的是营收（而不是利润。上市的标准之一是年营收四千万以上）。
- DD（尽职调查）。投资之前会审查集团和子公司之间的所有协议，包括管理费细则与理由（所以集团需要合并办公来进一步扩大理由）、分红是否由子公司董事会提案（所以分红也要走子公司董事会流程），并且会要求投资之后引入新的外部董事（但允许大多数董事依然属于集团事业部）。
随着融资轮次越来越多，子公司董事会里的外部董事也将越来越多。在上市之前，属于集团事业部的董事通常会跌破三分之一；集团持股也可能跌破50%（但会通过其他协议来保障控制权）。
### 注意：消失的COO
在十多年前，以及更早，集团架构是有COO一职的，即：
- 股东会：分红权
- 董事会：决策权
- 监事会：监督权
- CEO：执行权
	- 审计部：检查财务部假账
	- 投资部：投资或收购其他公司（投资与自身互补的公司、收购潜在的竞争对手）
	- COO
		- 财务部：报销、记账、避税、计算利润
		- 法务部：拟定合同，处理法律纠纷
		- 人力部：招聘、培训、离职、员工档案、员工心理咨询、宣传企业文化
		- 行政部：采购、团建、物业、食堂、宿舍、安保、文员
		- 公关部：媒体品牌形象与影响力（西贝没有独立公关部、而是行政部兼任公关，所以闹出罗永浩事件、舆论自杀。大集团都有单独的、专业的公关部）
		- IT部：内部软件
	- 总裁
		- 云团事业部（领导被称为副总裁，或者云团总裁）
		- 风神界事业部
		- ……
COO让CEO从繁琐的日常事务中解放出来，让CEO可以专注于战略规划。这似乎是一个很自然的职位。
但是，从2010年开始，越来越多的公司取消了COO，改为直接由CEO对接下面这些部门。
到如今2025年，大企业已经很少有COO了，主流架构都是CEO直接对接各部门。
为什么？
因为COO的权责边界不清晰。
COO这个职位有几个糟糕的特点：
- 它几乎无法独立运作，它不是一个封闭的系统，它必须要CEO的配合或授权。什么叫封闭？财务部是封闭的，外人不需要关心财务专业知识，最终呈现出来的只是一个报表。各个部门，包括人力部、各个事业部，也包括总裁，都是封闭的。唯独COO不是封闭的。
- COO需要频繁打扰CEO、要求CEO做许多CEO不完全理解的事情（COO会给出理由，但理由中涉及到许多CEO此前从不了解的公司信息，CEO很难考证是否真实、以及真实的话它的程度数值是大是小，是否真的如COO所说的那样重要），在CEO眼里、COO带来的各种意外非常多（当然，比各部门直接对CEO汇报要少很多）。CEO无法通过一次授权来一劳永逸的免除打扰。或者说，如果CEO试图通过一次授权来一劳永逸，那么将会导致COO成为第二个CEO，权力极大——而这将导致COO做出许多CEO意料之外的事情，要求或裹挟CEO配合COO的行动（虽然数量相比于之前更少了，但单次的让CEO厌恶的强度更大了）。
- COO会做出一些【损害短期，为了长期】的事情，这将导致CEO的问责。各部门会甩锅【COO让我干的】，而COO的解释、CEO因为缺乏信息而难以判断、并因【长期的收益是看不到的，短期是损失是实打实的】而厌恶。CEO自己可以为了长期损害短期，但不会允许其他人这样做。
- COO无法做到无损封装信息。如果CEO想要消除对COO的不满，那么CEO需要亲自了解各部门的具体信息，这样才能理解COO行为的理由。
这导致，COO很难真正为CEO节省精力。即便设立COO，CEO也依然需要具体了解各部门的情况、而不能只听笼统汇报。
因此，现代企业渐渐的取消了COO，直接让CEO对接各部门了。
### DS：这个文档存在事实性错误吗？
基本正确：
1. **集团部门**：文档列出了股东会、董事会、监事会、CEO及其下属部门（财务部、审计部、法务部、人力部、行政部、公关部、IT部、投资部、总裁和事业部）。这是标准的企业结构，但具体可能因公司而异。例如，公关部可能不是独立的，而是由其他部门兼任；法务部也可能不是独立的，而是隶属于人力部。
2. **子公司结构**：文档提到子公司由集团全资控股，董事会由事业部人员兼任，不设CEO，领导被称为总经理。这符合常见做法，全资子公司通常由母公司控制，董事会成员由母公司指派。
3. **利润算法**：文档描述了集团通过管理费和分红来获取子公司利润。管理费被设置为高额以吃掉利润，然后集团注资弥补亏损，用于避税和控制。分红时，集团通过子公司董事会提案和股东会批准来合法化流程。文档提到IFRS要求合并财务报表，而不是只记录管理费和分红。这基本正确，国际财务报告准则（IFRS）和中国企业会计准则（CAS）都要求合并子公司的财务报表。
4. **合并办公**：文档讨论了合并办公的概念，提到了BP（业务合作伙伴）和SSC（共享中心），如HRBP和财务共享中心。这确实是现代企业的常见做法，尤其是大集团，以提高效率。
5. **子公司激励**：文档详细描述了总经理的激励措施，包括固定工资、年度奖金、任期激励和期权激励。期权激励的变现方式（分红、回购、并购、上市）也描述得相当准确。这些是标准的股权激励实践。
6. **独立上市**：文档提到子公司可以独立融资和上市，外部投资人投资的原因包括上市前景和尽职调查。文档指出，上市锚定的是营收而不是利润，并且集团持股可能跌破50%但通过协议保持控制权。这基本正确，上市标准通常包括营收要求，而母公司可以通过投票权协议或其他方式保持控制。
不过，文档中仍有一些可能误导的地方：
- **子公司利润算法**
	- **文档内容**：集团通过高额管理费吃掉子公司利润，然后注资弥补亏损，用于避税和控制；分红时通过子公司董事会提案和股东会批准；IFRS要求合并财务报表。
	- **潜在问题**：文档提到“极其高额的管理费，几乎可以吃掉所有利润”。这在理论上可行，但必须符合“ arms-length principle”（公平交易原则），否则可能被税务机关视为转移定价违规或逃税。现实中，管理费需要合理反映集团提供的服务价值，不能任意设置。
- **合并办公**
	- **文档内容**：合并办公是常见做法，提到BP（如HRBP）和SSC（如财务共享中心），并认为合并办公为高额管理费提供理由。
	- **潜在问题**：没有事实错误，但合并办公并不总是为高额管理费提供“更好的理由”。管理费仍需基于实际服务成本和市场水平，否则在尽职调查或审计中可能被挑战。共享服务中心（SSC）确实能提高效率，但费用分摊必须公平。
- **子公司激励**
	- **文档内容**：详细描述了总经理的激励措施，包括固定工资、年度奖金、任期激励和期权激励。
	- **潜在问题**：文档说“一个合格的总经理都能拿满年度奖金”，但这取决于KPI设置和公司绩效。现实中，奖金可能设置得具有挑战性，并非所有总经理都能轻松拿满，否则激励效果会打折扣。通常来说，60%至80%是一个合理的范围。
- **独立上市**
	- **文档内容**：子公司可以独立融资和上市，外部投资人投资的原因是上市前景和尽职调查；上市锚定营收；集团持股可能跌破50%但通过协议保持控制权。
	- **潜在问题**：文档提到“上市的标准之一是年营收四千万以上”，这过于简化。上市标准因交易所和板块而异，例如，中国A股科创板的营收要求是最近一年营收达到3亿元、或者最近三年营收复合增长率达到20%。因此，“四千万”可能是一个举例，并不是通用标准。
-  **消失的COO**
	- **文档内容**：从2010年开始，越来越多的公司取消了COO。到如今2025年，大企业已经很少有COO了。
	- **潜在问题**：COO（首席运营官）职位确实在一些公司中减少或消失，尤其是科技公司。但在传统行业（如制造业、零售业）依然常见。文档的陈述过于绝对，它夸大了一个趋势，忽略了现实多样性。（回应：确实。因为传统行业比较稳定可预测，COO不会经常给CEO带来意外）