## 封面
作者：执悲今厄，千里未来，浊浪逝风
时间：2024.8.27-2024.8.28
## 摘要
本文是一个自我认知过程。[[何谓自我认知与内觉]]
首先介绍了一组【同环境不同行为】的案例：
- 环境：需要达成共识
- 行为：三请三辞/藕式共识
然后提取共性：耳濡目染、教育印证等。
然后对众多共性抽象为一个更本质的共性：正循环。
然后对此本质共性进一步剖析为底层先天机制：生成判断，学习机制。

持有如下问题的人可以看本文：
- 具体如何通过自我认知来得到人脑原理？给我一个全过程，我希望模仿着去做自我认知。
- 生成判断机制真的存在吗？有哪些案例可以证明它的存在？
- 生成判断机制与学习机制是怎样的？请定位叙述。（定位叙述：侧重于明确一个知识在知识海中的精确位置，而不是这个知识的精确内部构成。）
## 关键词
#关键词/学习机制 
#关键词/生成判断机制 
#关键词/自我认知 
#关键词/AGI 
#关键词/三请三辞 
## 正文
### 三请三辞
A：我父亲突发重病，现在医院需要人手，你能来帮忙吗？
B：好。
（一番忙活，情况稳定）
A：现在这个情况，出院后还要修养数月甚至数年。护理费不少。
B：我每月可以出一点。
A：不用。
B：到时候再说吧。
（一个月后，出院）
A：定了疗养院，每月5000元。
B：我给你每月拿一千。
A：不用。
B：拿着。
A：真不用。我父亲的病，你没有义务做这些。你住院时能帮我我就很感谢了，不能再麻烦你。
B：这话说的，咱俩是不是兄弟？你父亲就是我父亲。拿着。
A：（深吸口气）嗯。好兄弟。这个情我记住了。
### 藕式共识
A：我父亲突发重病，现在医院需要人手，你们能来帮忙吗？
B：好。
C：好。
D：好。
E：好。
（一番忙活，情况稳定）
A：现在这个情况，出院后还要修养数月甚至数年。如果在家，那么日夜需要人照顾，护理费不少；如果在疗养院，那么患者可能孤独。
B：我能出点护理费。
C：在家修养，我可以偶尔照顾。在疗养院，我可以偶尔探望。
D：在家修养，我可以经常照顾。在疗养院，我可以偶尔探望。
E：（沉默）
A：感谢各位的付出。我整理提案：在家，白天我照顾，晚上D照顾，偶尔C来替我们，B每月出500元。患者每月总成本大约3000元，其余成本我出。各位有异议吗？
B：没有
C：没有
D：没有
A：嗯，那就如此。
（一个月后）
D：这一个月累死了。之前的提案作废，晚上我照顾不了了。在家的话可以三天照顾一次。
A：开会。重新提案：在疗养院，每月成本五千，B每月出1000，其余成本我出。前期每天探望一次，每次两小时，两周后改为三天探望一次。C负责四分之一探望，D负责四分之一探望，我负责四分之二。各位有异议吗？
B：有。我希望出500，而不是1000。
C：没有。
D：有。我每月可以出300。
E：（沉默）
A：重新提案：在疗养院，每月成本五千，B每月出500，D每月出300，其余成本我出。前期每天探望一次，每次两小时，两周后改为三天探望一次。C负责四分之一探望，D负责四分之一探望，我负责四分之二。各位有异议吗？
B：没有
C：没有
D：没有
E：（沉默）
A：那么如此执行。
### 优缺点分析
#### 三请三辞
**定义**
对方提议他付出，即便你想接受，也要拒绝。要等他再提议，你再拒绝，再提议，你才可以接受。

**优点**
- 给对方的情绪价值高，让对方确信【你很重视他的这份帮助，你未来会回报他】。
- 给对方一个台阶，对方可以【当你拒绝后，对方不再提议付出】，且不会被你批评【你居然不帮我】。如果对方不是真的想付出，但又担心被你批评，那么可以走这个台阶。

**缺点**
- 低效率。一个简单的事情需要推拉三五次，浪费三五倍的时间。
- 耗算力。每一次拒绝与提议，双方都要耗费脑细胞去构造理由，既保证【自己的理由支持自己的行动（拒绝/提议）】，又保证【如果自己在客套（准备下回合改变行动），那么自己的理由不会堵死对方（堵死：对方下回合无法构造理由）】。
- 不适合多人场景。在多人环境中，三请三辞会导致效率以几何倍数暴跌，甚至永远无法达成共识。因为你永远不知道对方是在客套还是真话，各位观点一直在变，每一个人的变化都会导致其余人对旧提案做出的准备动作作废，基于此导致其余人的观点也变。
#### 藕式共识
**定义**
诸位提出自己的想法，由负责人汇总整理为一个完整的提案，然后诸位再基于此提案提出自己的想法，然后负责人再次汇总……直至诸位对提案无异议。

**名字由来**
由于讨论的历史是【发散-汇总-发散-汇总】，如同藕节，因此称为藕式。另外，三请三辞在多人环境中的讨论历史是圆锥曲线，最终可能以椭圆模式收敛，也可能以双曲模式发散（即永无共识），人越多越趋向于双曲。

**优点**
- 高效率。每个人都说真话，每一次发言都是最高信息量的发言。
- 适合多人讨论。治众如治寡。多人讨论时，复杂度不会指数增长，而是线性增长。（线性增长：多一个人，会议就多十分钟。指数增长：多一个人，会议就多一倍时间。三请三辞是指数增长）

**缺点**
- 冰冷。缺乏情绪价值，付出者感受不到对方对自己的付出的重视，感受不到对方未来的回报。
#### 杂感
苹果手机创始人乔布斯说过：我喜欢和聪明人打交道，因为不用考虑他们的尊严。
记者问：聪明人的尊严就可以被随意践踏吗？
乔布斯说：你误会了。我的意思是，聪明人不会在意语气、形式等问题，只会关注内容。跟聪明人说话时，我要做的是表达清楚我的观点；跟蠢人说话时，我要做的是调整自己的语气、试探对方的态度，为此通常需要牺牲发言的准确性、降低谈话效率。
乔布斯的观点可以被概括为：不要三请三辞，要藕式共识。
### 问与答
问：藕式共识中，如何保证各位的付出会在未来获得回报？
答：习惯于藕式共识的人，会把诸位的付出记在心里，不需要强调，即可百年不忘。每一次会议都是一个记忆节点。

问：如果他就是忘了，或者故意装作忘记，那么我怎么办？
答：没办法，除了无意义地骂他。但这只能说明藕式共识不完美，不能说明三请三辞优于藕式共识。因为，如果三请三辞的人未来故意忘记、不回报你，那么你除了狂怒谩骂之外也没有其他办法。

问：有完美的办法吗？
答：有，合同。但那太麻烦了，因此综合性价比而言，生活中最好的办法是藕式共识。
### 人脑原理
人的每一个行为，都由先天算法与后天经历决定。每个人的先天算法一致。人们的行为方式不同，本质是后天经历不同。

喜欢三请三辞的人：
- 耳濡目染。从小，家庭中都是三请三辞，孩子模仿。
- 教育印证。孩子被父母教育要三请三辞，然后执行，并渐渐的感受到三请三辞的高情绪价值好处，然后习惯于三请三辞。
- 奖励印证。孩子第一次谦让时被夸奖，此后孩子更多的谦让，更多的夸赞与奖励。
- 内正顿悟：一次自己不想接受对方的付出，对方强烈要求，自己改变主意、接受。然后发现对方很高兴。于是顿悟【未来即便想接受，也要先装作不想接受的样子，这样对方会高兴】。

三请三辞的初等经历例如：
- 饭桌上的唯一鸡腿要给父母，父母拒绝，再给，再拒绝，才自己吃。
- 对往来不是很密切的亲戚，压岁钱要拒绝，亲戚再给，再拒绝，再给，才接收。

喜欢藕式共识的人：
- 教育印证。被教了藕式模式，执行发现好处，习惯。
- 分析。分析出藕式模式好。相信分析（因为有大量基于分析做事的经验）。
- 外正顿悟。原本头疼于多人管理，认为无解。然后发现别人用藕式共识解决了，震撼，顿悟。

两类人的共性：都会被耳濡目染、教育印证、奖励印证、内外顿悟、信任偏移所影响。（信任偏移：基于对分析的信任、藕式共识来自分析、因此信任藕式共识。再比如，你信任偶像，偶像说要藕式共识，于是你也信任藕式共识。）
这份共性，就是先天算法。两类人的差异，只在于后天具体接受了怎样的模板/教育/奖励/内外/信任。
严格的描述是：
- 耳濡目染机制：如果一个人周围有很多其他人，且其他人都在面对情况X时做F(X)，那么这个人也会在面对情况X时倾向于做F(X)，且随着时间的推移、做的F(X)越来越多、后续倾向也越来越强（如无干扰。干扰例如下面的机制）。
- 教育印证机制1：如果一个人经常被强制在X时做F(X)，然后发现F(X)的好处，那么未来会倾向于在X时做F(X)。做得越多，倾向越强。
- 教育印证机制2：如果一个人被教育要在X时做F(X)、这会有好处Y，然后执行后果然获得Y，那么未来会倾向于在X时做F(X)。做得越多，倾向越强。
- 奖励印证机制：如果一个人因随机行为或意外缘故而在X时做F(X)，并获得夸奖，那么未来会倾向于在X时做F(X)。做得越多，倾向越强。
- 内顿悟机制：如果一个人因随机行为或意外缘故而在X时做F(X)，并获得意料之外的好的结果，并且这个结果是过去自己经常求而不得的，那么会顿悟，此后坚决执行在X时做F(X)。
- 外顿悟机制：如果一个人希望在X时实现某个好的效果Y，但认为无法实现、接受用差的效果Z，但看到别人用F(X)实现了Y，那么会顿悟，此后坚决执行在X时做F(X)。
- 信任偏移：如果一个人在A时做G(A)，第一次遇到X时属于A，且此时G(A)＝F，那么此后坚决执行在X时做F(X)。

基于此可以得到一个更本质的机制：
- 正循环机制：一个人有越多的【在X时做F(X)取得好的结果】的经验，那么未来越会倾向于在X时做F(X)。
    - 初次经验可能来自于随机行为、暴力要求、连哄带骗。
    - 好的结果包括本身效果与额外奖励。额外奖励：糖果，夸赞。
    - 如果获得了强烈的好的结果，那么会强烈的倾向（顿悟）。强烈的好的结果例如【解决了一个【自己一直想解决、无法解决、绝望的接受了不完美解】的问题】。
    - 对于【X时做F(X)】，F(X)的结果可能并非结束动作，而是一个阶段动作。阶段动作例如函数：【F(X)＝G】。

问：正循环机制与信任偏移中的FG字母是不是乱了？
答：二者之间字母重置。正循环中的字母不依赖于前文。

问：正循环机制如何表现出信任偏移的【坚决】？依靠最后一个特性吗？不够吧？
答：信息偏移中的坚决，本质是通过【前期，每次遇到类似情况都会运行最后一个特性，带来同样的结果。后期，依靠正循环】实现。
正循环是【越做就越想做】。与之对应的是【越做就越不想做】，即厌倦机制，它的案例例如【游戏玩腻】【经常被恭维就不再因此愉悦】。严格定义为：
- 厌倦机制：一个人越多、越轻松的受到某一个奖励，那么就越发不重视此奖励。
这个看上去和正循环机制相反，但看定义可以发现，它实际上只能作为正循环机制下的一个特性。

比正循环更本质的是：生成判断机制。
比厌倦更本质的是：学习机制。
- 生成判断机制：做事时，是生成一个想法，判断要不要做。不做则重新生成新的想法，直至判断为做。
    - 生成是联想式的，基于当前情景、自身目标，联想过去的行为。一类行为越多越容易被联想到。
    - 生成在联想时，短期记忆的权重高。
    - 判断基于【是否有理由表明这个行为会带来不好的结果】，如果无法想到理由那么就同意。
    - 单次判断不需要充分理由。以收敛为输出。（收敛：连续多次的生成判断，生成的都相同，判断的都是做）
- 学习机制：如果一个人在X时做F(X)，意外获得某个好的结果，那么愉悦，并学到【在X时做F(X)可以实现某个好结果】。
- 学习机制：如果一个人认为在X时做F(X)能实现某个好的结果，但不确定，然后执行，果然实现，那么愉悦，并强化【在X时做F(X)果然可实现好结果】。
    - 好的结果包括美食、尊重等。
    - 【确定】非理性。父母承诺今天吃大餐，父母一直履行承诺，也是不确定。确定来自于生成判断全程无否定，而一旦联想到过去没大餐、就是一次否定。

问：生成判断如何实现正循环？
答：
- 对于第一次行为，随机生成时，生成此行为，判断为无否决理由，执行。
- 对于后续行为，生成时生成概率越来越高。
- 前文正循环的条件【如无干扰】，本质是【如判断时无理由否决】。
- 顿悟带来的强效果，本质是短时间内思绪万千。（可内觉观察到：顿悟时超高速大量一阶思考。一阶思考：下一次思考几乎不基于上一次思考，所有思考都只基于原始问题）

问：学习机制如何实现厌倦？
答：经常获得奖励，就不再【不确定】，从而不再收获愉悦，从而表现为厌倦。
### 总结
本文是一个自我认知过程。[[何谓自我认知与内觉]]
首先介绍了一组【同环境不同行为】的案例：
- 环境：需要达成共识
- 行为：三请三辞/藕式共识
然后提取共性：耳濡目染、教育印证等。
然后对众多共性抽象为一个更本质的共性：正循环。
然后对此本质共性进一步剖析为底层先天机制：生成判断，学习机制。