### 作品信息
作者：执悲今厄
时间：2024.9.10
### 摘要
实现AGI的流程是：先构建一个基于行为树（先天）的动作社会，再逐渐消除先天、添加后天、保证社会稳定。直至纯后天，AGI完成。
本文介绍了行为树的具体用法。有以下问题的读者可以读本文：
- 行为树是什么？怎么用它实现一个动作社会？
- 为什么使用行为树来作为迭代的起点？而不是大模型或者其他的东西？
- 你是怎么想到要用行为树的？因为看别人用行为树吗？
### 关键词
#关键词/动作社会 
#关键词/行为树 
#关键词/AGI 
#关键词/内觉迭代法 
#关键词/降阶法 
### 声明
由于本文遭受了许多批评，因此此处统一回复。

第一，本文所谓的行为树，是【我创造了一个算法，它与业内的行为树类似，因此我将其称为行为树。我学习业内行为树方案，攫取其中的众多思想、融入我的算法中】，而非单纯的【我学习业内的行为树】。
我不希望看到以下质疑：
- 你这不是行为树，你这使用了状态机思想
- 你这不是行为树，你这连多帧动作都没有
- 你这不是行为树，你这连控制节点都没有
（并且，我这样【创造与攫取】的学习/研究方式，远优于单纯的学习。是聪明的表现。）
第二，如果有人质疑【你自己创造这个算法太差了，远不如业内的行为树方案】，那么我的回应是：
- 行为树可以兼容状态机思想，黑板中可以有状态字段。而且我未来会修改记忆算法，不以黑板为记忆。
- 多帧动作我未来大概不会增加，但我会用新的记忆结构来实现多帧动作的表现。（每帧决策与行动+行动影响记忆+下一帧决策基于记忆=行动连贯=多帧动作）
- 我知道if结构不好，未来我会将其封装，但封装的结果未必是控制节点。控制节点是业内基于多帧动作而设计的。

另：动作社会定义见于【动作社会理念】。
### 智能的本质是函数
第一，智能必须存在于环境之中。
第二，所谓智能，本质就是两个函数：
- 环境函数：$F(环境,动作)=环境$ 
- 智能函数：$F(环境,记忆)=(动作,记忆)$ 
这两个函数每帧运行。
开发AGI，就是定义这两个函数。所谓的价值万亿的AGI算法，就是这两个函数的定义。

对于地球，环境函数就是物理规则。
下一瞬间的世界，等于上一瞬间的世界按照物理规则演变。
特别的，智能的动作也遵从物理规则。因此地球环境函数可以描述为：$F(环境)=环境$ 
但【以物理规则实现智能】的话，AGI研发太麻烦。因此我们简化为：$F(环境,动作)=环境$ 

对于地球，智能函数就是人类行为。
智能函数中的环境就是视听嗅味触的输入信号。
智能函数中的动作就是肌肉的运动。包括眼部肌肉、喉咙肌肉、四肢肌肉等。
每一刻，我们接收五感，做出运动，更新记忆。这就是$F(环境,记忆)=(动作,记忆)$ 
有的人质疑：我们并不是时刻运动。
对此：你拿一个传感器在手上，尝试保持手静止不动，你会发现：传感器表明你的手每秒不规则运动了上千次。并且这不是传感器的问题：你把传感器放在桌子上，传感器显示桌子不动。
你就是在时刻运动，所谓的静止是基于时刻调整姿态的动态平衡。婴儿无法站立，因为站立需要时刻调整姿态，婴儿没学会。

环境函数简单，这里不多介绍。下文介绍智能函数。
问：环境函数怎么就简单了？
答：如果使用地球环境，那么环境函数极难、需要超越时代的物理学。但如果架空一个游戏环境，那么环境函数简单。
问：游戏环境凭什么实现AGI？
答：后天学习能力强的就是AGI。学习能力不依赖于环境。（修订者注：使用学习能力时，才需要环境。当谈论【拥有学习能力】时，不依赖于环境。学习能力可以用于任何环境。）
### 函数的本质是映射
映射，是指一个输入对应唯一一个输出。
要定义函数，一个简单的办法是，我们可以做一个映射表，罗列：
- 当环境为A1，记忆为B1时，$F(环境,记忆)=(C1,D1)$ 
- 当环境为A2，记忆为B2时，$F(环境,记忆)=(C2,D2)$ 
- ……
把所有情况罗列出来，这样函数的定义就完成了。

但这样太麻烦了。环境有几乎无数种，记忆也几乎无数种，这样罗列的话、罗列到天荒地老也罗列不完。
对此我们可以改良一下，把【环境是XX】改为【环境满足XX性质】。例如：
- 当环境满足【存在：食物】，记忆满足【存在：我饿】时，$F(环境,记忆)=(吃饭,记忆-我饿)$ 

但这样还有一个问题：性质可能交叉。例如，映射表中存在【满足A性质时做X】【满足B性质时做Y】，但遇到一个【既满足A，又满足B】的场景，这时候怎么办？
对此，需要使用【带优先级的映射表】。一种简单的优先级是：从上到下。对于表格的每一行，依次判断，如果某一行判断通过，那么就结束、后面的行不再处理。
即，如果表格中【满足A性质时做X】这一行在上方，那么遇到【既满足A，又满足B】的场景就做X。如果表格中【满足B性质时做Y】这一行在上方，那么遇到【既满足A，又满足B】的场景就做Y。

但这样还有一个问题：性质可能不全。例如，遇到一个场景、不满足表格中的一切性质。这时候怎么办？
对此，需要使用【带默认行为的映射表】。即，映射表的最后一项是【如果以上都不满足，那么执行默认行为：XXXX】。

如此，我们可以以【带优先级、带默认行为的映射表】来定义智能函数。
### 行为树
行为树是对【带优先级、带默认行为的映射表】的最后一点改动。
映射表中经常会存在这样的情况：
- 如果环境与记忆满足性质A且B且C，那么XXX
- 如果环境与记忆满足性质A且B且D，那么XXX
- 如果环境与记忆满足性质A且E，那么XXX
- 如果环境与记忆满足性质F，那么XXX
- ……
对此，使用树的形式简化：
- 如果满足A：
	- 如果满足B：
		- 如果满足C，那么XXX
		- 如果满足D，那么XXX
	- 如果满足E，那么XXX
- 如果满足F，那么XXX

行为树可以简单的实现动物级别的智能。
举个例子：沙漠中有一种甲虫，它们吃蚂蚁，并且会在遇到冷风时竖起身体、凝结水珠来喝。这种甲虫可以用如下行为树描述：
- 如果听到大声响，或者自己受到攻击，那么加速逃跑，朝着声响与攻击的反方向。  
- 如果遭遇冷风，那么竖起来身体，然后如果水落下，那么喝水。如果冷风结束，那么回归正常。 
- 如果视野内有蚂蚁，且自己饱食度小于80%，那么追击。如果追到，那么吃。如果蚂蚁消失，那么自己正常。  
- 如果上述都不是，那么随机移动。

上面的描述不严谨，严谨的描述字数很多。
我用另一个更简单的例子来严谨的展示一下行为树的描述：一个矿工采矿，在矿石与基地之间往返。
- 如果记忆中存在【开采】：
	- 如果背包没满：
		- 如果所在位置不是矿石
			- 朝着矿石方向移动
		- 否则
			- 开采矿石
	- 否则
		- 记忆中移除【开采】
- 否则
	- 如果背包没空：
		- 如果所在位置不是基地
			- 朝着基地方向移动
		- 否则
			- 卸货
	- 否则
		- 记忆中添加【开采】
### 优缺点
优点：
- 简单。行为树虽然看上去比较复杂，但其实最多花十个小时就能掌握。相比于毫无头绪的【模仿人脑来定义AI】，行为树算得上是非常简单了。
- 强大。《钢铁雄心》等战略游戏，还有体育游戏，其中使用行为树定义的AI可以让玩家难以分辨出【那是真人还是AI】。
	- 钢铁雄心：玩家扮演国家领袖，发展工业、军事、经济，处理外交、内政、战争，基本目标是活下去、高级目标是征服世界。全世界数十国家，其他国家的领袖是各个AI，AI会各种随机应变、复杂战术，经常杀得玩家哭爹喊娘。
	- 体育游戏：例如足球类游戏，玩家扮演一个球员，其他球员是AI。AI同样会随机应变，走位、传球、射门，技术远强于一般玩家。
缺点：
- 学习能力弱。行为树实现的AI虽然能随机应变，但难以后天学习，同样的错误会重复的犯。你无法通过批评、夸奖、教育等方式改变AI的行为。（根源在于：记忆系统太简陋）

问：那么，开发动作社会游戏时，要不要使用行为树？
答：要。
第一，行为树可以搭建出来一个【乍一看真实】的社会性世界。（玩家通常20小时内不会觉得世界僵硬）
第二，行为树搭建出来一个基本世界之后，可以在此基础上逐渐优化记忆结构、削减先天能力、强化后天能力，并保证社会表象不变。如此直至实现AGI。参考：内觉迭代法
### 总结
问：伪智能体的动作社会不可能简单实现。只能用AGI算法或者大模型。
答：错。可以用行为树。

问：行为树实现的动作社会没意义。
答：错。可以用内觉迭代法，以行为树为开端，以AGI为结束。

问：什么是行为树？
答：智能的本质是函数，函数的本质是映射表，【性质化的、有优先级的、有默认行为的、以树简化的映射表】就是行为树。
注意，这不是我对业内行为树的复读，这是我对业内行为树使用降阶法的结果。降阶法：XXX

问：行为树已经存在几十年了，为什么其他人没有使用行为树实现AGI、反而火了大模型？
答：行为树改造为AGI时需要使用新记忆结构。
新记忆结构是：每一条记忆的格式是生成判断序列，例如【这里有一个床】在记忆中存储的是【这么走，不，那么走，不，躺下，可以，如果别人问你家有几个床那么我回答一个，可以，回答两个，不】。生成判断序列可以抽象化（主要抽象为情绪）、可以部分合并，两个记忆之间可以定义超维距离（并在抽象/合并时位置变化），联想是以概率云的方式大概获取距离近的。
其他人没有生成判断理论，自然无法改造行为树。
另外：A出现，B大乘，不代表A废物。
哺乳动物早就出现，然而爬行动物此后称霸亿万年，然后哺乳再起。
行为树早就出现，然后大模型称霸数年，然后行为树再起。