### 通用人工智能
通用人工智能（AGI），是指和人一样、甚至超越人类的人工智能。AGI会让世界进入新时代，如同两千万年前第一次猿猴下树，如同四十亿年前第一个单细胞生物的诞生，这是智能层次的跃迁。
当代的阿尔法狗，GPT，自动驾驶，距离AGI都差着十万八千里。
我们无法预估AGI会带来怎样的结果，也许是如同打开了潘多拉魔盒、带来战争与毁灭，也许是从此生产力爆发、资源免费、人们无需工作即可奢侈享受，也许是生物改造、机械飞升、从此人类离开地球走向宇宙。
但是，无论结果是好是坏，AGI必将到来。无数科学家前仆后继的投入到AGI的研究之中，AGI是时光长河中最璀璨的明珠，是无数人心中的梦。它就在时光长河中伫立着，无论我们是快是慢，我们终将触摸到它。
我是一名AGI研究者，从人类行为与念头入手研究，目前已有数千篇研究文档、拆解了数千个人类行为案例，提出了一套理论来解释所有行为。本专栏分享一些我的研究文档。
我相信：任何人的任何一个行为，其原因都可归结于先天因素与后天因素两部分，并且所有人的先天因素相同。完全明确先天因素之日，就是AGI的实现之时。
### 研究文档标题后缀
后缀主要有两种。
R：表示【升级到人脑原理】。例如【人际交流：提问成本与回答成本-R】，表示【本文先介绍了人际交流中的一个现象：提问成本与回答成本，然后讨论了这个现象背后的人脑原理】。
SR：表示【升级到思维方式，然后进一步升级到人脑原理】。例如【人际交流：三请三辞与藕式共识-SR】，表示【本文先介绍了人际交流中的一个现象：三请三辞与藕式共识，然后讨论了这个现象背后的思维方式，然后讨论了这个现象/思维背后的人脑原理】。

无后缀的文档千奇百怪。
可能是综述性质的，结合大量案例文档来得出高级结论、或者整理大量案例文档中提到的AGI算法碎片；
也可能是信息性质的，介绍AGI的含义、AGI的未来；
还可能是对AGI研究方法的叙述。
还可能是其他的……
总之，一切不存在【话题A已经结束、文章本身完整了，但又升级到话题B】的文档，都是无后缀的。

R与SR这种带后缀的文档最常见，大多数研究文档都是带后缀的。这种带后缀的文档被我称为【指数文档】，取【文档的信息量随着字数的增加呈指数增长】之意。
另外，我的AGI项目也是一个指数项目。我会在虚拟环境中开发AGI，而这个虚拟环境本身可以简单改编为一款沙盒开放世界游戏、带来百亿收入，AGI研发完毕后更是可以带来万亿收入。
### AGI项目
- 第一阶段，搭建一个沙盒开放世界环境，存在众多分工分级的简易AI-NPC。（分级：有统治阶级）
	- 改编游戏：玄幻世界观，2D、非像素、俯视图、实时演算，单机买断制。
	- 改编游戏：玩家与NPC同权。NPC没有的东西玩家也没有（比如等级奖励），玩家没有的东西NPC也没有（比如锁定饱食）。百万NPC的行为影响世界格局与物价演变，玩家开局只是世界中平凡的一员。
	- 改编游戏：类似《KenShi》。预计收入一亿。
- 第二阶段，基于我的AGI理论，强化NPC的后天学习能力。
	- 削减NPC的种类，将原本先天不同的一些NPC改为【先天相同，后天不同，导致行为方式不同】。同时保证社会稳定。
	- 二代游戏：网游订阅制。除了订阅、皮肤、交易税之外，没有其他内购，一切资源产出都是玩家与NPC按照世界规则采集或制造的。
	- 二代游戏：类似《EVE》。预计收入百亿。
- 第三阶段，AGI实现。
	- NPC的种类削减到1。众多相同算法的AGI婴儿将在前辈NPC的引导下后天的形成分工分级的社会（初代NPC非AGI）。
	- NPC的学习与创造能力非常强，以至于创造了一种语言文字、在虚拟社会中形成共识。（这被我视为AGI的标志）
	- 注册AGI专利。收取专利授权费：机器人企业、互联网企业、新兴企业（基于AGI技术的新服务）、各国政府。预计收入万亿（AGI将带来百万亿市场）。
### AGI理论概括
我本不想概括我的AGI理论，因为它听上去比较匪夷所思。如果只看理论，那么你会觉得它狗屁不通；随着你看我拆解各种案例，你才会越来越发觉这个理论的奇妙之处；但在这个过程中我会丢失很多读者，所以我不希望这样。我希望先讲案例与初步拆解，等我讲了大量案例与初步拆解之后，这时候我再介绍我的理论、深入拆解那大量案例，最后我再概括性描述。
但有的读者就希望提前看概括。因此，如果你认为自己不会误解我的概括，那么可以看下面我对我的AGI理论的概括：
（再次强调：它看上去匪夷所思、违背直觉，但你看我后续拆解案例后会觉得它合理。并且，也正是因为真相匪夷所思，所以才千百年无人勘破。）

人的行为的原因包括先天因素与后天经历，所有人的先天因素是一样的、区别只在后天。这个相同的先天，就是生成判断机制。
每秒万次，每次生成动作、判断是否执行，生成判断基于记忆、又影响记忆。生成与判断基于联想，不负责，连续多次判断通过的才会执行。意识本质是记忆中的一些信息，干预判断、使其能够更坚持地否决某些重复的生成，每一次干预成功都会强化，一秒可强化千百倍。意识不干预生成。
生成判断如海，意识如风暴，可以于海上自发酝酿而生、愈演愈烈，也可随时消散。意识从未真正存在过，意识无核，人的一生会经历千万次意识寂灭，又经历千万次意识苏醒。
大量的生成判断可以构成高级结构，如预测器、解释器、语言器。
生成判断之外，还存在：输入系统、输出系统、短期记忆系统、长期记忆系统、插入系统。但这些不重要，可被人类感觉亲切的智慧生命的这些系统完全可以与人类不同，但生成判断必然相同。人类的一切人性的缺点，都来自于生成判断机制的缺陷。

注意：生成判断不是一个拍脑子想出来的理论。它有数千案例支撑，有二十多条性质约束，并且大概还有未被发现的新性质。
### 总结
本专栏将记录我对AGI的一些研究文档。
同时，接受投资。投资人/机构请发邮件到[1181807822@qq.com]，标题格式为：【投资】XX公司XX职务（或自由人），内容介绍你为什么对我的项目感兴趣、以及其他你想介绍的信息，并留下你的QQ或微信联系方式。我会在三天到一个月内回复（即便是拒绝），不会让你的邮件石沉大海；如果我对你也感兴趣，那么我会加你的联系方式进一步交流。