### 象棋残局
![[大征西.png]]
红先黑后，红能赢吗？
路边一个老大爷摆摊，你交一百元后可以执红、老大爷执黑，基于这个残局而下棋。如果你赢了，那么老大爷给你一千元。
交不交？

一般人都会开始思考。思考一番后决定要不要交钱。
怎么思考的？是这样的：
- 如果我是红，那么我会怎么下？
- 平前炮将军。对方吃炮。然后我平后炮再将，对方再吃。然后我下车将，完美！
- 不对，下车的话，对方会炮打。
- 没关系，我可以先下右车，然后对方炮打，然后我再下左车，绝杀。完美！
- 一千块就这样就能赚？是不是有什么陷阱？我检查一下。
- 对方两个卒一步杀，没错。但对方不会有机会走卒，因为我步步将军。
- 对方能不能在解将的同时反将我？不能。车吃炮，炮打车，都不是反将。
- 对方能不能走别的？不能。我炮将军，他要是不吃，而是躲车，那么我重炮绝杀了。
- 对方如果躲车，那么能反将吗？也不能。
- 检查的没问题，我必胜！

一些厉害的棋手会想到这里：
- 不对，对方第一个炮必须吃，但第二个炮可以不吃、而是平车挡车，这样我就没法连杀了，然后对方拱卒我死。
- 大陷阱！这个局面黑必胜啊！
- 不对，我不需要送炮。我完全可以第一步拱兵将军，他必须吃我，因为上将的话我下车绝杀。然后他吃了的话将就在中间，我平车将军抽中卒，然后防御无敌。红必胜！
- 检查一下。我抽卒之后他下车将怎么办？没关系，我垫车呗。我净多三个大子，必胜。
- 检查的没问题，我必胜！

更厉害的棋手还会想到更多的演变。最终结论是：最优解下，九十六步后双方和棋。这九十六步里，一方走错任意一步，另一方都会获胜。
具体棋谱本文不继续讲了，感兴趣的可以去搜索【大征西】，这是象棋江湖排局八大名局之一。
本文基于上面介绍的思考过程，讲一下人的一种思维方式：生成-判断。

上面的思维过程是一个经典的生成判断过程。其中的生成判断包括：
- 生成一个走法，判断这个走法能否取胜。
- 生成【我能赚到一千】，判断【不对，不能这么简单】或【对，我检查没问题了】。
- 生成对方的一个应对策略，判断这个策略能否反杀我。
- 生成【这就是一个陷阱，红棋赢不了，不必思考了】，判断【确实】或【不能下定论这么早，我再看看】。

有的人说：你咋想的这么多？我没有生成判断，我就是盯着这个棋局看，然后解法就自动出现在大脑里了。
对此，我的回复是：解法不可能自动出现。你的思维过程具体可能与我不同，但一定也是大量的生成-判断，只不过你没有观察到生成判断的过程。
至于为什么没观察到：
可能是因为你是职业棋手，有大量的经验，导致你对此生成判断的太快了，一个生成的方案在一微秒后否决，你一秒生成了上千个想法、你的意识还没来得及看清一个想法它就被否决删除了，所以你才觉得意识看不到任何东西、大脑一片空白、最终自动出现了一个解法。
也可能是因为你的观察能力很弱，平时说话也不过脑子，导致你观察不到自己的思维过程。

注意：意识是一个观察者，而不是一个行动者。你的思考并不是意识决定的，是大脑自动进行的，意识只是观察到思考的过程而已。
因此，你没观察到你的思考，不代表你没有思考。

有的人说：这只能表明在思考象棋时是生成判断。其他时候未必。
对此，我的回复是：我一开始也是这么想的，认为生成判断只是一种高级的思维技巧、而不是底层的。
但后来我发现，许多原本认为不是生成判断的，本质是【快速的难以观察的生成判断】。这一点我会在后续的文档中进一步讲解。
#AGI/生成判断
### 树形与代码格式
有人认为：这是树形的思维。即，伪代码例如：
``` C#
遇到金钱棋局
    下炮，对方吃
        下炮，对方吃
            下车，绝杀
            不对，对方炮杀
            下右车后下左车
        不对，对方横车
        没有其他办法了
    这里就有问题。应当拱卒
	    对方不吃，那么我绝杀
	    对方吃，那么我将军抽中卒，胜局已定
```
这是表意识的思维表象。但不是人脑的算法原理。理由：
第一，AI算法中不可能存在【下炮】这种概念。下炮是一个成年人基于其记忆而得到的一个概念，而AI算法是婴儿的。【AGI算法+记忆=成年AGI体】。
第二，即便是同样的人，在同样的环境下，其思维过程也会不同。因此思维过程不可能是一个树（因为树是固定的），只能【思维过程可以表现为一个树】。

基于生成判断，伪代码例如：
``` C#
遇到金钱棋局
生成一个想法，判断通过或否决
生成一个想法，判断通过或否决
生成一个想法，判断通过或否决
……
```
其中，生成器基于记忆与噪音而生成。判断器基于记忆与意识与噪音而判断，同时每一次判断本身加入记忆、导致下一次生成变化。
噪音的存在解释了少量的随机性。且生成判断算法与记忆是剥离开的，让AGI算法只是生成判断算法、而不掺杂记忆。
基于我的记忆，我生成的想法历程可以表现为一个树，具体内容如上文。但一定注意：树是表象，本质就是连续的生成判断。

当然，具体生成器如何基于记忆与噪音而生成，判断器如何基于记忆与意识与噪音而判断，这目前还不清楚。
但有一些理论碎片，例如：记忆的格式是生成判断序列。
对于【这有一个床】，记忆为【我往这走，否决。我往哪走，否决。我躺下，可以】。
对于【我摔到了】，记忆为【环境-行为-反馈】，其中环境例如上面的床的记忆序列，行为就是生成的【往前走】，反馈是【生成走路，否决。生成看景色，否决。生成大叫，同意】。
