### 原始场景
一名厨师，一名后勤主管，一名CEO。
众口难调，厨师头大，因此CEO让后勤主管负责制定菜单、让厨师只负责执行。（众口难调：大量诉求，甚至可能彼此矛盾：有的人爱吃某菜、有的人不爱吃）
一段时间后，大家依然对菜品有很多不满，很多不含矛盾的诉求都没有得到满足。
### 序
CEO是教师，主管是学生。
教师：B类套餐里不要含有芹菜等粗纤维嚼不烂的食物。你周三的B套餐里有韭黄。为什么？因为你觉得韭黄不是粗纤维？
学生：不是。我忘了B套餐里不要粗纤维了。上百条诉求，太多太乱了，我头都要大了。
教师：记笔记，记录所有诉求。
学生：我记了，想不起来看。或者说，我会看，但看的时候容易漏看。
教师：你是直接凭直觉改菜单，然后看一眼诉求表，觉得没什么问题的话就提交。而不是对着诉求表一个一个检查。是吗？
学生：是。是我太懒了吗？可一个一个检查太麻烦了啊！它不是只检查一遍就够的。它的复杂度是指数增长的，因为每发现一个诉求没满足、重新修改菜单时，都需要再次从头检查，因为修改后可能与过去的诉求出矛盾。啊，感觉这个工作好难……一个菜单问题居然会这么麻烦……
教师：这就是一个基础的数学问题，类似我之前在[[智商：万剑归宗]]里的爱因斯坦问题。并且，除了列方程之外，还可以使用素数问题中常用的筛法。你知道筛法吗？
学生：不知道。
教师：陈景润用筛法在哥德巴赫猜想里证明了1+2（哥德巴赫猜想是1+1）。筛法取素数的思想可以简单理解为：给出来1到10000的数字集，然后把2的倍数删除，3的倍数删除……这样筛一遍，剩下的就是素数。
学生：这跟此处有什么关系？
教师：数学建模。给每个套餐构建【所有菜品种类集】，然后用诉求表来筛一遍，然后对剩下的菜品排列组合得到套餐。
学生：这样只能处理对无关时空的单菜品诉求。可是还有一些非单菜品的诉求，比如【一份套餐里不能有两个豆制品】。还有一些时间限制的诉求，比如【一周一次大虾】。
教师：这些非单菜品诉求不超过总诉求的20%吧？当做特殊情况来处理，构建一个【特殊诉求集】，然后使用之前说的【凭直觉制定菜单后，对着特殊诉求表一个一个检查】。
学生：震惊。好办法。我会认真反思。
### 第一课
教师：我教你做笔记吧。从上次的菜单问题可以看出来你不会做笔记。
学生：好。是。
教师：先看一下这个文章：[[【超凡入圣】知识库构建方法]]。你有什么要说的吗？
学生：看完了，但我不知道我现在要做什么。以菜单问题为例，如何在菜单问题上应用这个文档中的方法？
教师：你直接新建几个文件：
- 单诉求表
- 特殊诉求表
- A套餐菜品集
- B套餐菜品集
- C套餐菜品集
- 菜单
然后开始工作，执行筛法。并且每次遇到诉求，都记录到诉求表里，并执行一次新的筛。
月末的时候把它们整理到【核心区/办公/菜单问题/】之下。你刚开始，核心区内容不多，那么也可以放在【核心区/菜单问题/】之下。
注意一定不要现在放。要在整理的时候再放，切忌直接在核心区中新建文件（否则核心区会变为垃圾场，很多文件新建的时候觉得很棒、实际过几天就成了垃圾）。月末如果这六个文件因为其他原因而被废弃了，那么就不整理到核心区，而是丢到垃圾区里。
并且，对于我教学过程中的优质结论，比如之前让你说【震惊，好办法】的那段话，你可以新建一个文件后复制进去。（注意，同样是月末整理）
学生：为什么要做核心区呢？为了便于查找吗？
教师：查找是次要作用。主要作用是让你明确自己的全知识结构，从而便于产生跨学科的感悟，就像是我之前随手把数学筛法用于菜单问题。
学生：我不理解这个逻辑关系。明确知识结构和产生跨学科感悟之间有什么关系？
教师：玄妙关系，这是人脑的一个玄妙现象。我没法直接解释，但我可以说一个同级：晕车问题。假设你坐车，不能看手机、看手机就头晕，但需要坐一个小时的车，那么你是否会感觉很煎熬？觉得一个小时荒废了：不能刷手机摄入信息，也不能思考问题，因为坐车时深度思考也头晕。那么这时候你就可以做一件事情：只明确问题，不思考。你可以想着一个问题，也可以想着三五个问题，你不需要去思考它，你只需要问自己【有哪些问题值得思考】。保持自己在坐车全程中脑海中都存在问题（问题本身可能会变化，你全程可能会想到几十个问题，但同一时刻只存在不超过三五个问题）。然后你下车了，缓解一下大脑，拿出来手机便签，现在你正式认真思考一些你车上产生过的某个问题，这时候你会发现你灵感泉涌，越写越兴奋。对此我称之为：只要你明确了问题，你潜意识就会自动开始思考。（注意，要复现的话，关键点在于【下车后你需要再执行一下“明确问题”、以及你明确的问题需要是在车上产生过的问题】。灵感不会自动出现，但会在你表意识思考问题时出现）
学生：神奇的现象……
教师：此处也是一样。只要你明确了知识结构，你的潜意识自动就会开始对它们搅拌、混合思考，从而让你在解决生活问题时产生各种跨学科的灵感。
学生：知道了。
### 第二课
学生：我有一个问题。核心区怎么明确所有知识结构？需要定期回看所有内容吗？那太累了。
教师：标题索引。你要让自己能做到【看标题就能回忆起所有正文内容】。
学生：啊？这怎么可能做到？
教师：训练。我经常讲纪录片训练法：看一个纪录片，然后自己做笔记，使得结束后你可以看着笔记回忆起纪录片里的所有重要内容、能够用你的语言复述出来这个纪录片。笔记最好简短，不超过一百字，通常是一些破碎的词汇。
我之前写过我发现这个方法的经历：
``` C#
小时候，我经常生病，请假在家。父母摆摊卖菜，我一个人在家，那时候没有手机电脑，只有电视，于是我看电视。当时喜欢在CCTV3看综艺，在CCTV9看纪录片。
吃饭的时候，父母会跟我聊天，问我病情，给我讲菜价。我不想聊这些东西，于是我就给他们讲我从电视上看到的东西、主导话题。他们也认真听，认真聊，还夸赞我懂的真多、说听我讲这些让他们学到新东西了。我很开心，于是更加认真的讲。且他们的夸赞主要是在我讲纪录片时，因此我渐渐更多的讲纪录片，讲宇宙，讲动物。
有的时候我会忘记很多东西，讲到一半卡壳。还有的时候我知道有某个好玩的东西、但我死活想不起来到底是什么，只记得在看纪录片时产生过【好玩】这个想法本身。于是我开始记笔记，在看纪录片的同时在草纸上简单记录一些词汇作为提示，当我给父母讲解时、偶尔看一眼草纸。
吃饭时，夏天傍晚纳凉时，散步时，冬天烤火烤地瓜时，都是我在讲各种东西。包括纪录片，也包括书籍。讲数学，讲政治，讲武器，讲传记。
我在看纪录片、看书的时候，做的笔记也更加完备。看完之后我会检查笔记、完善笔记，使得我确认我可以对着笔记回忆起所有内容；如果检查时发现某些遗忘的地方，那么就再看一遍书中的对应部分，然后完善笔记。
这时候，也让我发现了一个最重要的定理。这个定理看上去很显然，但却一直被我忽视，相信也被很多人忽视。它就是：**笔记，就是目录**。
对于那些优秀的书籍，我最终整理出来的笔记，往往与书的目录一模一样。所以后来我很少做笔记了，直接看着目录回忆全书。
```
学生：传奇。但我感觉我很难复现。
教师：教你一个简单的办法：起标题时，做二层上级定位。这样你看核心区时，就只需要看所有标题就够了，不需要看内容；只对于那些看标题不知道什么意思的文章，再看内容。比如之前的【单诉求表】改为【 【永恒】收集表：单诉求表】，其中永恒表示长期更新的文档。这样就不会忘记这个文档是干嘛的。
学生：其他文档怎么写二层上级定位？比如【事件+事件引发的知识】格式的文档：
``` C#
事件：为什么有人会去选择做只有短期收益的事情
知识：人喜欢做轻易的选择，而不是做复杂的选择
```
教师：可以起名为【自我管理：人类愚蠢行为（目光短浅）】。如果你的事件案例更详细一些，比如特朗普关税横跳、短期赚钱、长期败坏美国信誉，那么也可以起名为【阅历感悟：目光短浅之人（特朗普关税）】。
学生：知道了。
### 评论
暮已归人：
核心区还有一个作用：避免遗忘。避免重复造轮子，避免越前进越后退。
重复造轮子：曾经我写的大量灵感都以碎片文件的形式存在，但写完就忘。我最近在写世界观，很麻烦，但我随机找一些我过去的docx文件，里面有大量写好的世界观。如果当时我整理到核心区，那么现在就不需要重复造轮子。
越前进越后退：忘忧草最近视频质量严重下滑（修订者注：此处发言时是四月初）。他变蠢了吗？不是。他持有ABC而做出好视频，然后深入研究C来优化视频，但研究C时忘掉了A，导致基于B与强化后的C而做出来的视频质量反而变差。他最近也开始整理理论，找回来了一些A（视频理论几百条，ABC简化模型）。（修订者住：五月份时果然发布了三百万播放的新作品）

浊浪逝风：
【不允许在核心区新建文件】是一个很难做到的事，但也是一个重要的事。
执悲今厄提出的这个笔记方案，我实践的效果很好。很多人没有提出，我认为关键就是在于没意识到【不允许在核心区新建文件】。
这种【关键在于禁止】的特征，让我想起来计算机中的栈结构：栈就是列表加上禁止随意更换数值。栈明明是阉割的列表，但地位却远高于列表。

天涯剑歌：
我在实践中做了调整：把【外置记忆】文件夹从核心区里独立出来，与核心区同级。
外置记忆里可以放账号密码、工商信息、Linux指令等。这个区域经常需要用，因此给它减一级折叠度来方便打开。
当然，它的规则与核心区一致：不允许新建文件，仅允许月末整理时移入移出。（但可以编辑旧文件）
（联想：诺奖提出压强理论，院士发明菜刀，教授改良菜刀木柄曲线，博士研究【当菜刀与电钻一起对墙进行破坏性施工时可以给菜刀套上聚乙烯袋子来避免粘上电钻扬起的粉尘】。执悲今厄像是诺奖兼院士，我像是教授（狗头））
### 关键词
#关键词/待定/数学建模：筛法菜单
#关键词/待定/跨学科感悟：晕车问题
#关键词/待定/知识库构建：进阶解释
#关键词/待定/回忆能力：纪录片
#关键词/待定/笔记：二层上级定位