### 前言
通用人工智能算法值多少钱？
一百万？一千万？一亿？十亿？
都不是。
而是，一万亿元起步。
通用人工智能的应用的市场将百万亿元起步。作为其中最核心的技术专利，通用人工智能算法将价值市场的至少1%，即一万亿元。
### 通用人工智能
通用人工智能（AGI），是指和人一样、甚至超越人类的人工智能。AGI会让世界进入新时代，如同两千万年前第一次猿猴下树，如同四十亿年前第一个单细胞生物的诞生，这是智能层次的跃迁。
当代的阿尔法狗，GPT，自动驾驶，距离AGI都差着十万八千里。
AGI将改变几乎所有行业。
### AGI时代：科技爆发
科学技术的研究需要智力，AGI是智力的跃迁。
我所研究的AGI，虽然算法与人类一样，但是算力不同：AGI的大脑可以轻松扩容，而人类不可以。
大脑扩容，对智力的提高其实并不明显，但它可以解决一个关键的问题：合作时的沟通问题。
当代的各行各业，包括研究院、公司、政府，一个非常大的问题就是沟通问题带来的低效。一旦一个工作要协调五十个部门，那么这个工作的推进就将非常艰难，除非由一个具有强大领导才华与地位的人来全权负责，这样才能让这个工程以缓慢的进度前进。然而，如果不需要沟通，大家心灵融合、互相理解，那么效率将会千百倍的提高。
大脑扩容之后，一个人就可以完成几百人甚至几万人的工作，不需要沟通。这是AGI的一个关键性质。

另外，AGI还有另一个关键性质：可复制。
人类的智慧不可复制，教学难，爱因斯坦那样的天才的去世令人惋惜。
然而AGI不同，如果一个AGI后天的成长成了伟人，那么它的后天记忆库将可以被完全复制，它将永生不死。

这里定义一个概念：每天价值产出。计算公式是：
$$每天价值产出=每天工作时间×单位时间工作量×单位工作量价值潜力×价值发挥率$$
AGI天才与人类天才的单位工作量价值潜力差不多（由世界科技成果决定），价值发挥率差不多（由智力决定），但是：
- AGI天才的每天工作时间是人类的五倍。人类天才平均每天只能高效率工作4小时左右，而AGI可以工作24小时
- AGI天才的单位时间工作量是人类的上万倍。人类天才的效率是1人力，而AGI外接超算之后、可以控制上万条机械臂或联网机器人，效率是10000人力。
因此，AGI天才的每天价值产出效率万倍高于人类。

科学技术的进步基于价值产出量。因此，AGI将会带来科技爆发，例如：
- 可控核聚变
- 超导体
- 量子计算机
- 宇宙航行
- 癌症
### AGI时代：建筑与教育行业
虽然科技很厉害，但其实我们从科研行业赚的钱不会太多。
AGI专利授权费高的行业例如建筑、教育、军事。

建筑方面，一切建筑工人都下岗，AGI全面负责建造。大型机械臂，小型机器人，所有设备都由一个拥有服务器级算力的AGI实时控制。效率高，成本低——只有电费与折旧，而且可控核聚变之后电费廉价。
目前全球建筑行业规模为五十万亿元，AGI会带来建筑行业的爆发、使得AGI建筑行业的规模就上百万亿元。
问：现在楼房都饱和，建筑行业不会爆发。
答：现在只是传统楼房饱和而已。智能建筑，娱乐城，远远没有饱和，尤其是智能建筑。
AGI之后，这些传统房屋都要拆掉重建，房屋本身联网，所有家具都是智能的。私人医生、律师、保洁、厨师、管家、司机、伴侣……每个人都将可以拥有奢侈的享受。

教育方面，一切教师都下岗，AGI教师将能一对一的24小时照顾与培养孩子，并且AGI教师全程联网、接受最新的教育理论，相当于所有孩子都有世界最优秀的教师全天一对一指导。至于社交问题，AGI教师都会安排各种活动来让孩子拥有完美的社交。如果父母有某些特殊要求，AGI教师还可以推出几十种定制化的教育方案，比如培养孩子成为客套的人还是直率的人。AGI教师将真正的做到【德智体美劳】的教育，而不是单纯的学术教育。
当脑机接口技术突破时，教育行业将迎来再一次革命，AGI教师也将失业，人类将可以通过脑机接口来提升算力。记忆芯片、算数芯片、脑联网、知识上传与下载……这将是人类自我跃迁的唯一窗口，绝大多数的精英人才将会不惜一切代价的投入到学习与自我改造之中。在遥远的未来，AGI终将将人类远远地甩在身后，如同人类将猴子甩在身后。要想不被淘汰，唯一的办法就是：猴子跟着其他猴子下树，一起成为人类；人类自我改造，与AGI一起进化为新文明：单帝模式文明。（单帝模式：见于本专栏文章《通用人工智能算法（二）：说谎与鉴谎-R》）
这第二轮革命中，教育行业的规模也将突破百万亿，甚至到达千万亿。

军事方面就不多说了，因为讲军事必然涉及到讲政治。
简单说一下：AGI将带来格局动荡，因为一个小国可以凭借AGI来迅速超越大国。比如AI参政，小国可以说上就上，大国至少讨论三个月，然而AGI时代高速迭代、三个月世界都变天了。各国实力大幅度变化，世界局势必然高度紧张，军事行业也将是百亿甚至千亿规模的。AGI无论是作为士兵、将军、还是军工科研人员，都是重中之重。

未来各行各业都需要AGI+。说AGI市场百万亿，那都是保守估计。
### AGI时代：失业与金钱
大下岗是在所难免的。别说人类了，AGI都会失业，如同我前文所说的AGI教师将在脑机接口时代失业。
AGI时代的社会迭代速度是非常快的。三年，甚至一年，甚至三个月，甚至到后期一个月就会迭代一轮。甚至，九月一号一个新职业诞生，九月二号这个新职业火爆，九月三号这个新职业被另一个职业所取代，这都不稀奇。随着AGI的发展成熟，社会的总价值产出速度将越来越大，科技成果将井喷式发展，进一步扩大价值产出速度，导致越来越快。
这一切将在单帝模式的到来时终结。届时，社会秩序将彻底重新洗牌，没跟上车的人与AGI将被淘汰，人类作为古老的词汇留作纪念，文明进入星际时代。
（单帝模式：见于本专栏文章《通用人工智能算法（二）：说谎与鉴谎-R》）

但也不用太害怕失业。
首先，AGI时代社会生产能力爆发，养活这些人类只需要全世界不足万分之一的资源，根本不成问题。直接高福利，每月按人头发钱，这笔钱足以让你过上你所享受的生活，但不足以在脑机接口时代上车。（AGI就没有这么好命了，AGI不会被发钱，它们需要自己赚钱来至少支付自己的电费。所以你可以花钱获得AGI的服务。）
然后，不必担心金钱失去意义。即便是在单帝模式社会，金钱依然有意义。
金钱，作为社会合作所需的媒介，只要在有社会存在的地方、就会有金钱的存在。金钱的形式可以变化，可以是人民币、美元、比特币、黄金、新形态，但无论如何，金钱本身这个抽象的概念不会消失，并且即便存在新生的金钱形式、也必然有一段窗口时间可以让你将旧形式的金钱以不算太亏的价格转化为新形式。
### 总结
未来各行各业都将结合AGI，通用人工智能的应用的市场将百万亿元起步。
作为其中最核心的技术专利，通用人工智能算法将价值市场的至少1%，即一万亿元。
问：通用人工智能这种大事不会作为专利。不要太相信法律。甚至还有其他意外。
答：我自有办法。不便公开。