# 降阶法
## 定义
降阶法，可以让你基于一个你能看懂的优秀的东西、迅速达到与其相同的水平。  
可以用于：
- 阅读他人的优秀劝谏，从而提高自己的劝谏水平
- 阅读他人的优秀小说，从而提高自己的小说写作水平
- 阅读数学答案，从而提高自己的数学水平
- 阅读他人的优秀结构的代码，从而提高自己的代码结构水平
- 阅读他人的平面设计图，从而提高自己的平面设计水平

降阶法的操作是：对于那个优秀的东西，它被称为一个高阶的存在。把它转化为从低阶到高阶的一系列东西，使得：
- 你会第一阶
- 如果你会X阶，那么你会X+1阶
- 那个优秀东西是最终阶
## 案例：劝谏
出师表  
亲贤臣，远小人，此先汉所以兴隆也；亲小人，远贤臣，此后汉所以倾颓也。  
先帝在时，每与臣论此事，未尝不叹息痛恨于桓、灵也。  
侍中、尚书、长史、参军，此悉贞良死节之臣，愿陛下亲之信之，则汉室之隆，可计日而待也。  

第一阶：  
侍中尚书长史参军，你要亲近他们。  
因为他们是贤臣。

第二阶：  
亲近贤臣是正确的。  
所以你应该亲近贤臣。  
侍中尚书长史参军，这四个是贤臣。  

第三阶：  
亲近贤臣是正确的。  
但是很多人没有认识到这一点。  
我希望你认识到这一点。  
侍中尚书长史参军，这四个是贤臣。  

第四阶：  
译文  

第五阶：  
原文  
## 案例：编程
第一步，找到一段优质代码  
第二步，明确这段代码的原始问题（它要实现什么功能）  
第三步，你自己实现那个功能，写代码。这是第一阶  
第四步，对比你自己的代码与优质代码，找出一个【我的代码应当按照XX思想而修改】，然后执行。得到第二阶  
第五步，反复执行第四步。对比第二阶与优质代码，找出一个欠缺的思想，然后执行，得到第三阶。再对比……直至你的代码与优质代码一样（或超越）。  
## 案例：平面设计
和编程差不多。  
第一步，找到一个优质的平面设计图  
第二步，明确这个图的原始目的（它要用来做什么）  
第三步，你基于原始目的，自己设计一个平面图。这是第一阶  
第四步，对比你自己的图与优质的图，找出一个【我的图应当按照XX思想而修改】，然后执行。得到第二阶  
第五步，反复执行第四步。对比第二阶与优质图，找出一个欠缺的思想，然后执行，得到第三阶。再对比……直至你的图与优质图一样（或超越）。  
### 案例：小说写作
第一步，找到一个优秀的小说
第二步，明确这个小说的大纲、详纲
第三步，你自己尝试从大纲写出来它的详纲，尝试自己从详纲写出正文
第四步，对比你的3与原作，找出一个【我写出来的东西应当按照XX思想来改进】，然后执行
第五步，反复执行第四步，直至你的作品与原作一样（或超越）
#学习方法/降阶法：吃透价值
### 优点：破除无穷接近阈值
降阶法可以解决一个致命的问题：无穷接近阈值
无穷接近阈值：你在努力做一个工作，需要做到超越阈值才会有成就。但你很努力，却一直无法到达阈值，总是在不断接近，总是无法到达。

不使用降阶法的人，通常是【对高阶的东西不断降阶，但总是无法理解】。
降阶法并不是【对高阶的东西不断降阶】，而是【对高阶，找到能理解的低阶，对低阶不断升阶，直至与高一致】。
即，降阶法是【明确首尾，连线】。一般人是【只明确尾，下降，永远到不了头】。
### 易错点：没做到【第一阶必须你会】
第一阶必须是你会的，必须是完完全全从你出发而独自得到的，不允许【对着答案来尝试还原出第一阶的样子】。
你必须遗忘答案，彻底遗忘，除了答案的原始目的（题目）之外，你不允许记得任何东西。第一阶必须是你对题目的完完全全的亲自作答。
什么是题目？比如出师表那一段的题目是【作为一个了解下属们的才能与品行的宰相，你如何劝皇帝亲近侍中尚书长史参军？】。
### 易错点：没做到【每一步必须抽象】
从第一阶到第二阶，你必须抽象出来一个原理，使得【第一阶+改进原理=第二阶】。这才叫你懂了第二阶。
从第X阶到第X+1阶同理。
什么是原理？比如我前文中出师表第一阶到第二阶就没法写出来一个原理。需要改为：

第一阶：  
侍中尚书长史参军，你要亲近他们。  
因为他们是贤臣。

第二阶（三段论化）：  
你要亲近贤臣。
侍中尚书长史参军，他们是贤臣。
所以你要亲近他们。

第三阶（进一步三段论）：
因为你要我们的国家强盛。
因为案例表明：亲近贤臣则国家强盛，不亲近贤臣则国家衰落。
所以你要亲近我们的贤臣。
因为侍中尚书长史参军，他们是我们的贤臣。
所以你要亲近他们。

第四阶（禁止断言上位者的目的。即，将【你的目的是A，所以你需要做B】柔化为【我希望你做B，这样你会得到A】）：
案例表明：亲近贤臣则国家强盛，不亲近贤臣则国家衰落。
侍中尚书长史参军，他们是贤臣。
我希望你亲近他们，这样我们的国家会强盛。

第五阶（引用资料时不可有说教嫌疑、否则让人抗拒资料。即，禁止毫无理由的引用一个资料。即，引用资料来说教时、需要额外伪装一个看似合理的理由，例如怀旧叙旧。）
我想起来你父亲了，他常常跟我说：亲近贤臣则国家强盛，不亲近贤臣则国家衰落。他越说越叹气，我也替他忧愁。
话说现在。侍中尚书长史参军，他们是贤臣。
我希望你亲近他们，这样我们的国家会强盛。

每个括号里的是抽象结果。
### 易错点：缺乏审美能力
有的人不会升阶。根本原因在于：你根本没有审美能力，你不知道一个答案好不好。
降阶法是建立在审美的基础上的，建立在【你真的知道你要模仿的这个东西好】，而不是【听别人说它好，所以你觉得它好】。
在审美的基础上，当你得到一阶之后，你可以把它和原文对比，如果不一致，那么以二者连线、得到改正的方向，沿着那个方向、按自己的想法走一步，再审美【走完这一步后，是否更美了】，是的话就留下来，完成一次升阶，然后继续下一次；不是的话就重新走。
只有你不会审美，无法判断自己走完是否更美了，这时候你才会无法升阶。